/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.rs;

import java.util.Optional;
import org.silverpeas.kernel.logging.SilverLogger;

public enum AuthenticationScheme {
    BASIC,
    BEARER;


    public static Optional<AuthenticationScheme> from(String scheme) {
        try {
            return Optional.of(AuthenticationScheme.valueOf(scheme.trim().toUpperCase()));
        }
        catch (IllegalArgumentException ex) {
            SilverLogger.getLogger(AuthenticationScheme.class).error("The authentication scheme " + scheme + " isn't supported", (Throwable)ex);
            return Optional.empty();
        }
    }
}

