/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.ws.rs.FormParam;
import javax.xml.bind.annotation.XmlElement;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.http.RequestFile;
import org.silverpeas.core.web.http.UnescapeHtml;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class RequestParameterDecoder {
    private static final RequestParameterDecoder decoder = new RequestParameterDecoder();
    private static final String XML_ELEMENT_DEFAULT_NAME_VALUE = "##default";

    protected static RequestParameterDecoder getInstance() {
        return decoder;
    }

    public static <O> O decode(ServletRequest request, Class<O> objectClass) {
        return RequestParameterDecoder.decode(HttpRequest.decorate(request), objectClass);
    }

    public static <O> O decode(HttpRequest request, Class<O> objectClass) {
        return RequestParameterDecoder.getInstance().decodeReq(request, objectClass);
    }

    public static <T> OffsetDateTime asOffsetDateTime(T object) {
        if (object instanceof OffsetDateTime) {
            return (OffsetDateTime)object;
        }
        if (object instanceof String) {
            String typedObject = ((String)object).trim();
            return OffsetDateTime.parse(typedObject);
        }
        if (object != null) {
            throw new IllegalArgumentException();
        }
        return null;
    }

    public static <T> boolean asBoolean(T object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            String typedObject = ((String)object).trim();
            return StringUtil.getBooleanValue((String)typedObject);
        }
        if (object != null) {
            throw new IllegalArgumentException();
        }
        return false;
    }

    public static <T> Long asLong(T object) {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            String typedObject = ((String)object).trim();
            if (StringUtil.isLong((String)typedObject)) {
                return Long.valueOf(typedObject);
            }
            return null;
        }
        if (object != null) {
            throw new IllegalArgumentException();
        }
        return null;
    }

    public static <T> Integer asInteger(T object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            String typedObject = ((String)object).trim();
            if (StringUtil.isInteger((String)typedObject)) {
                return Integer.valueOf(typedObject);
            }
            return null;
        }
        if (object != null) {
            throw new IllegalArgumentException();
        }
        return null;
    }

    public static <T> Date asDate(T date, T hour, String userLanguage) throws ParseException {
        if (date instanceof String) {
            String typedDate = (String)date;
            String typedHour = (String)hour;
            if (StringUtil.isDefined((String)typedDate)) {
                return DateUtil.stringToDate((String)typedDate, (String)typedHour, (String)userLanguage);
            }
            return null;
        }
        if (date != null) {
            throw new IllegalArgumentException();
        }
        return null;
    }

    public static <E extends Enum<E>> E asEnum(String enumValue, Class<E> enumClass) {
        Method fromMethod = null;
        for (Method method : enumClass.getMethods()) {
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            if (method.getAnnotation(JsonCreator.class) == null || methodParameterTypes.length != 1 || !methodParameterTypes[0].isAssignableFrom(String.class)) continue;
            fromMethod = method;
            break;
        }
        if (fromMethod == null) {
            try {
                fromMethod = enumClass.getMethod("valueOf", String.class);
            }
            catch (Exception e) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
        }
        try {
            return (E)((Enum)fromMethod.invoke(null, enumValue));
        }
        catch (Exception e) {
            SilverLogger.getLogger(RequestParameterDecoder.class).warn((Throwable)e);
            return null;
        }
    }

    private <O> O decodeReq(HttpRequest request, Class<O> objectClass) {
        try {
            Constructor<O> constructor = objectClass.getDeclaredConstructor(new Class[0]);
            constructor.trySetAccessible();
            O newInstance = constructor.newInstance(new Object[0]);
            for (Field field : objectClass.getDeclaredFields()) {
                String paramName = this.findParameterName(field);
                if (paramName == null) continue;
                Object value = this.findParameterValue(field, paramName, request);
                if (field.getType().isPrimitive() && value == null) continue;
                field.trySetAccessible();
                field.set(newInstance, value);
            }
            return newInstance;
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    @Nullable
    private Object findParameterValue(Field field, String paramName, HttpRequest request) throws ParseException {
        Object value;
        boolean unescapeHtml = field.getAnnotation(UnescapeHtml.class) != null;
        Class<Set> parameterClass = field.getType();
        if (Collection.class.isAssignableFrom(parameterClass)) {
            AbstractCollection values = parameterClass.isAssignableFrom(Set.class) ? new HashSet() : new ArrayList();
            Class collectionHandledType = (Class)((ParameterizedType)field.getAnnotatedType().getType()).getActualTypeArguments()[0];
            value = this.getParameterValues(values, request.getParameterValues(paramName), collectionHandledType, unescapeHtml);
        } else {
            value = this.getParameterValue(request, paramName, parameterClass, unescapeHtml);
        }
        return value;
    }

    @Nullable
    private String findParameterName(Field field) {
        XmlElement xmlParam;
        FormParam formParam = field.getAnnotation(FormParam.class);
        String paramName = formParam != null ? (StringUtil.isDefined((String)formParam.value()) ? formParam.value() : field.getName()) : ((xmlParam = field.getAnnotation(XmlElement.class)) != null ? (!XML_ELEMENT_DEFAULT_NAME_VALUE.equals(xmlParam.name()) ? xmlParam.name() : field.getName()) : null);
        return paramName;
    }

    private Object getParameterValue(HttpRequest request, String parameterName, Class<?> parameterClass, boolean unescapeHtml) throws ParseException {
        Object value = parameterClass.isAssignableFrom(RequestFile.class) ? request.getParameterAsRequestFile(parameterName) : (parameterClass.isAssignableFrom(Date.class) ? request.getParameterAsDate(parameterName) : this.getValueAs(request.getParameter(parameterName), parameterClass, unescapeHtml));
        return value;
    }

    private Object getParameterValues(Collection<?> finalValues, String[] values, Class<?> parameterClass, boolean unescapeHtml) {
        if (values != null) {
            for (String value : values) {
                finalValues.add(this.getValueAs(value, parameterClass, unescapeHtml));
            }
            return finalValues;
        }
        return null;
    }

    private <T> T getValueAs(String parameterValue, Class<?> parameterClass, boolean unescapeHtml) {
        Object value;
        if (parameterClass.isAssignableFrom(String.class)) {
            value = this.asString(parameterValue, unescapeHtml);
        } else if (parameterClass.isAssignableFrom(OffsetDateTime.class)) {
            value = RequestParameterDecoder.asOffsetDateTime(parameterValue);
        } else if (parameterClass.isAssignableFrom(Long.class)) {
            value = RequestParameterDecoder.asLong(parameterValue);
        } else if (parameterClass.isAssignableFrom(Long.TYPE)) {
            value = RequestParameterDecoder.asLong(parameterValue);
        } else if (parameterClass.isAssignableFrom(Integer.class)) {
            value = RequestParameterDecoder.asInteger(parameterValue);
        } else if (parameterClass.isAssignableFrom(Integer.TYPE)) {
            value = RequestParameterDecoder.asInteger(parameterValue);
        } else if (parameterClass.isAssignableFrom(Boolean.class)) {
            value = parameterValue != null ? Boolean.valueOf(RequestParameterDecoder.asBoolean(parameterValue)) : null;
        } else if (parameterClass.isAssignableFrom(Boolean.TYPE)) {
            value = RequestParameterDecoder.asBoolean(parameterValue);
        } else if (parameterClass.isEnum()) {
            value = RequestParameterDecoder.asEnum(parameterValue, parameterClass);
        } else if (parameterClass.isAssignableFrom(URI.class)) {
            value = this.asURI(parameterValue);
        } else {
            throw new UnsupportedOperationException("The type " + parameterClass.getName() + " is not handled...");
        }
        return (T)value;
    }

    @Nullable
    private Object asURI(String parameterValue) {
        URI value = StringUtil.isDefined((String)parameterValue) ? URI.create(parameterValue) : null;
        return value;
    }

    private Object asString(String parameterValue, boolean unescapeHtml) {
        String value = unescapeHtml ? WebEncodeHelper.htmlStringToJavaString((String)parameterValue) : parameterValue;
        return value;
    }
}

