/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.service.job;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.silverpeas.components.mailinglist.service.event.MessageEvent;
import org.silverpeas.components.mailinglist.service.event.MessageListener;
import org.silverpeas.components.mailinglist.service.job.BetterMimeMessage;
import org.silverpeas.components.mailinglist.service.job.MailProcessor;
import org.silverpeas.components.mailinglist.service.model.MailingListService;
import org.silverpeas.components.mailinglist.service.model.beans.MailingList;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.mail.engine.SmtpConfiguration;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerEvent;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class MessageChecker {
    private static final String MAILING_LIST_JOB_NAME = "mailingListScheduler";
    public static final String IMAP_PROTOCOL = "imap";
    public static final String IMAP_SSL_PROTOCOL = "imaps";
    public static final String POP3_PROTOCOL = "pop3";
    private Map<String, MessageListener> listeners = new HashMap<String, MessageListener>(10);
    @Inject
    private MailProcessor processor;
    private String mailServer;
    private String login;
    private String password;
    private String protocol;
    private int port;
    private boolean leaveOnServer;
    private Session mailSession;
    @Inject
    private MailingListService mailingListService;

    public MailingListService getMailingListService() {
        return this.mailingListService;
    }

    public Session getMailSession() {
        return this.mailSession;
    }

    public void schedule(JobTrigger trigger) throws SchedulerException {
        Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
        scheduler.scheduleJob(MAILING_LIST_JOB_NAME, trigger, (SchedulerEventListener)new MessageCheckingListener());
    }

    public void unschedule() throws SchedulerException {
        Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
        if (scheduler.isJobScheduled(MAILING_LIST_JOB_NAME)) {
            scheduler.unscheduleJob(MAILING_LIST_JOB_NAME);
        }
    }

    public MessageChecker() {
        SmtpConfiguration smtpConfig = SmtpConfiguration.fromDefaultSettings();
        SettingBundle notifConfig = ResourceLocator.getSettingBundle((String)"org.silverpeas.mailinglist.notification");
        this.protocol = notifConfig.getString("mail.server.protocol");
        this.mailServer = notifConfig.getString("mail.server.host");
        this.login = notifConfig.getString("mail.server.login");
        this.password = notifConfig.getString("mail.server.password");
        this.port = notifConfig.getInteger("mail.server.port", smtpConfig.getPort());
        this.leaveOnServer = notifConfig.getBoolean("mail.server.leave", true);
        this.mailSession = Session.getInstance((Properties)new Properties());
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getMailServer() {
        return this.mailServer;
    }

    public boolean isLeaveOnServer() {
        if (POP3_PROTOCOL.equalsIgnoreCase(this.protocol)) {
            this.leaveOnServer = false;
        }
        return this.leaveOnServer;
    }

    public int getPort() {
        if (this.port <= 0) {
            if (POP3_PROTOCOL.equals(this.getProtocol())) {
                this.setPort(110);
            } else if (IMAP_PROTOCOL.equals(this.getProtocol())) {
                this.setPort(143);
            } else if (IMAP_SSL_PROTOCOL.equals(this.getProtocol())) {
                this.setPort(993);
            }
            this.setPort(110);
        }
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = POP3_PROTOCOL.equalsIgnoreCase(protocol) || IMAP_PROTOCOL.equalsIgnoreCase(protocol) || IMAP_SSL_PROTOCOL.equalsIgnoreCase(protocol) ? protocol.toLowerCase() : POP3_PROTOCOL;
        if (this.isImap()) {
            System.setProperty("mail.imap.partialfetch", "false");
        }
    }

    public synchronized void addMessageListener(MessageListener listener) {
        this.listeners.put(listener.getComponentId(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public void checkNewMessages(Date date) {
        block20: {
            Store mailAccount = null;
            Folder inbox = null;
            Map<String, MessageListener> listenersByEmail = this.prepareListeners();
            mailAccount = this.mailSession.getStore(this.getProtocol());
            mailAccount.connect(this.getMailServer(), this.getPort(), this.getLogin(), this.getPassword());
            inbox = mailAccount.getFolder("INBOX");
            if (inbox == null) {
                throw new MessagingException("No POP3 INBOX");
            }
            inbox.open(2);
            Message[] msgs = inbox.getMessages();
            if (this.isImap()) {
                FetchProfile profile = new FetchProfile();
                profile.add(FetchProfile.Item.FLAGS);
                inbox.fetch(msgs, profile);
            }
            HashMap<MessageListener, MessageEvent> eventsMap = new HashMap<MessageListener, MessageEvent>();
            for (Message msg : msgs) {
                this.processMessage(inbox, listenersByEmail, eventsMap, msg);
            }
            for (Map.Entry entry : eventsMap.entrySet()) {
                MessageListener mailingList = (MessageListener)entry.getKey();
                mailingList.onMessage((MessageEvent)entry.getValue());
            }
            try {
                if (inbox != null) {
                    inbox.close(!this.isLeaveOnServer());
                }
                if (mailAccount != null) {
                    mailAccount.close();
                }
                break block20;
            }
            catch (Exception ex2) {
                SilverLogger.getLogger((Object)this).error((Throwable)ex2);
            }
            break block20;
            catch (Exception mex) {
                try {
                    SilverLogger.getLogger((Object)this).error((Throwable)mex);
                }
                catch (Throwable throwable) {
                    try {
                        if (inbox != null) {
                            inbox.close(!this.isLeaveOnServer());
                        }
                        if (mailAccount != null) {
                            mailAccount.close();
                        }
                    }
                    catch (Exception ex2) {
                        SilverLogger.getLogger((Object)this).error((Throwable)ex2);
                    }
                    throw throwable;
                }
                try {
                    if (inbox != null) {
                        inbox.close(!this.isLeaveOnServer());
                    }
                    if (mailAccount != null) {
                        mailAccount.close();
                    }
                }
                catch (Exception ex2) {
                    SilverLogger.getLogger((Object)this).error((Throwable)ex2);
                }
            }
        }
    }

    private void processMessage(Folder inbox, Map<String, MessageListener> listenersByEmail, Map<MessageListener, MessageEvent> eventsMap, Message msg) {
        try {
            MimeMessage message = (MimeMessage)msg;
            if (this.isImap()) {
                if (!message.isSet(Flags.Flag.SEEN) && !message.isSet(Flags.Flag.DELETED)) {
                    message = new MimeMessage(message);
                    this.processEmail(message, eventsMap, listenersByEmail);
                }
            } else {
                this.processEmail(message, eventsMap, listenersByEmail);
            }
            if (this.isLeaveOnServer() && inbox.getMode() == 2) {
                msg.setFlag(Flags.Flag.SEEN, true);
            } else {
                msg.setFlag(Flags.Flag.DELETED, true);
            }
        }
        catch (IOException | MessagingException e) {
            SilverLogger.getLogger((Object)this).error(e);
        }
    }

    protected void processEmail(MimeMessage mail, Map<MessageListener, MessageEvent> eventsMap, Map<String, MessageListener> listenersByEmail) throws MessagingException, IOException {
        BetterMimeMessage email = new BetterMimeMessage(mail);
        if (email.isBounced() || email.isSpam()) {
            return;
        }
        Set<String> allRecipients = this.getAllRecipients(mail);
        Set<MessageListener> mailingLists = this.getRecipientMailingLists(allRecipients, listenersByEmail);
        for (MessageListener mailingList : mailingLists) {
            MessageEvent event;
            if (!eventsMap.containsKey(mailingList)) {
                event = new MessageEvent();
                eventsMap.put(mailingList, event);
            } else {
                event = eventsMap.get(mailingList);
            }
            this.processor.prepareMessage(mail, mailingList, event);
        }
    }

    protected Set<String> getAllRecipients(MimeMessage mail) throws MessagingException {
        HashSet<String> allRecipients = new HashSet<String>(10);
        InternetAddress[] addresses = (InternetAddress[])mail.getRecipients(Message.RecipientType.TO);
        if (addresses != null) {
            for (InternetAddress address : addresses) {
                allRecipients.add(address.getAddress());
            }
        }
        if ((addresses = (InternetAddress[])mail.getRecipients(Message.RecipientType.BCC)) != null) {
            for (InternetAddress address : addresses) {
                allRecipients.add(address.getAddress());
            }
        }
        if ((addresses = (InternetAddress[])mail.getRecipients(Message.RecipientType.CC)) != null) {
            for (InternetAddress address : addresses) {
                allRecipients.add(address.getAddress());
            }
        }
        return allRecipients;
    }

    protected Set<MessageListener> getRecipientMailingLists(Collection<String> recipients, Map<String, MessageListener> listenersByEmail) {
        HashSet<MessageListener> mailingLists = new HashSet<MessageListener>(recipients.size());
        for (String email : recipients) {
            MessageListener mailingList = listenersByEmail.get(email.toLowerCase());
            if (mailingList == null) continue;
            mailingLists.add(mailingList);
        }
        return mailingLists;
    }

    public synchronized Map<String, MessageListener> prepareListeners() {
        HashMap<String, MessageListener> listenersByEmail = new HashMap<String, MessageListener>(this.listeners.size());
        for (MessageListener listener : this.listeners.values()) {
            MailingList list = this.mailingListService.findMailingList(listener.getComponentId());
            if (list == null || list.getSubscribedAddress() == null) continue;
            listenersByEmail.put(list.getSubscribedAddress().toLowerCase(), listener);
        }
        return listenersByEmail;
    }

    public synchronized void removeListener(String componentId) {
        this.listeners.remove(componentId);
    }

    public MailProcessor getMailProcessor() {
        return this.processor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.login == null ? 0 : this.login.hashCode());
        result = 31 * result + (this.mailServer == null ? 0 : this.mailServer.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.isEqualTo((MessageChecker)obj);
    }

    private boolean isEqualTo(MessageChecker obj) {
        MessageChecker other = obj;
        if (this.mailServer == null && other.mailServer != null || this.mailServer != null && !this.mailServer.equals(other.mailServer)) {
            return false;
        }
        if (this.password == null && other.password != null || this.password != null && !this.password.equals(other.password)) {
            return false;
        }
        return this.protocol == null && other.protocol == null || this.protocol != null && this.protocol.equals(other.protocol);
    }

    protected boolean isImap() {
        return IMAP_PROTOCOL.equalsIgnoreCase(this.getProtocol()) || IMAP_SSL_PROTOCOL.equalsIgnoreCase(this.getProtocol());
    }

    public class MessageCheckingListener
    implements SchedulerEventListener {
        public void triggerFired(SchedulerEvent anEvent) {
            if (MessageChecker.this.listeners != null && !MessageChecker.this.listeners.isEmpty()) {
                MessageChecker.this.checkNewMessages(new Date());
            }
        }

        public void jobSucceeded(SchedulerEvent anEvent) {
        }

        public void jobFailed(SchedulerEvent anEvent) {
            SilverLogger.getLogger((Object)this).error("The job '" + anEvent.getJobExecutionContext().getJobName() + "' was not successfull", anEvent.getJobThrowable());
        }
    }
}

