/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.personalorganizer.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.personalorganizer.model.ToDoHeader;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.logging.SilverLogger;

public class ToDoDAO {
    static final String COLUMNNAMES = "id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, percentCompleted, completedDay, duration, spaceId, componentId, externalId";
    private static final String TODOCOLUMNNAMES = "CalendarToDo.id, CalendarToDo.name, CalendarToDo.delegatorId, CalendarToDo.description, CalendarToDo.priority, CalendarToDo.classification, CalendarToDo.startDay, CalendarToDo.startHour, CalendarToDo.endDay, CalendarToDo.endHour, CalendarToDo.percentCompleted, CalendarToDo.completedDay, CalendarToDo.duration, CalendarToDo.spaceId, CalendarToDo.componentId, CalendarToDo.externalId";
    private static final String DISTINCT_CLAUSE = "DISTINCT ";
    private static final String TO_DO_TABLE = "CalendarToDo";
    private static final String TO_DO_ATTENDEE_TABLE = "CalendarToDoAttendee";
    private static final String TO_DO_JOINING_TO_DO_ATTENDEE = "CalendarToDo.id = CalendarToDoAttendee.todoId";
    private static final String ORDER_BY_COL = ", lower(name) ln";
    private static final String ORDER_BY_CLAUSE = "ln";
    private static final String USER_ID_CRITERION = "userId = ?";

    private ToDoDAO() {
        throw new IllegalAccessError("Utility class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String addToDo(Connection con, ToDoHeader toDo) throws SQLException {
        int id;
        String insertStatement = "insert into CalendarToDo (id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, percentCompleted, completedDay, duration, spaceId, componentId, externalId)  values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(insertStatement);
            id = DBUtil.getNextId((String)TO_DO_TABLE, (String)"id");
            prepStmt.setInt(1, id);
            prepStmt.setString(2, toDo.getName());
            prepStmt.setString(3, toDo.getDelegatorId());
            prepStmt.setString(4, toDo.getDescription());
            prepStmt.setInt(5, toDo.getPriority().getValue());
            prepStmt.setString(6, toDo.getClassification().getString());
            prepStmt.setString(7, toDo.getStartDay());
            prepStmt.setString(8, toDo.getStartHour());
            prepStmt.setString(9, toDo.getEndDay());
            prepStmt.setString(10, toDo.getEndHour());
            prepStmt.setInt(11, toDo.getPercentCompleted());
            prepStmt.setString(12, toDo.getCompletedDay());
            prepStmt.setInt(13, toDo.getDuration());
            prepStmt.setString(14, toDo.getSpaceId());
            prepStmt.setString(15, toDo.getComponentId());
            prepStmt.setString(16, toDo.getExternalId());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
        return String.valueOf(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateToDo(Connection con, ToDoHeader toDo) throws SQLException {
        String insertStatement = "update CalendarToDo  set name = ?, delegatorId = ?, description = ?, priority = ?, classification = ?, startDay = ?, startHour = ?, endDay = ?, endHour = ?, percentCompleted = ?, completedDay = ?, duration = ?, spaceId = ?, componentId = ? , externalId = ? where id = ?";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(insertStatement);
            prepStmt.setString(1, toDo.getName());
            prepStmt.setString(2, toDo.getDelegatorId());
            prepStmt.setString(3, toDo.getDescription());
            prepStmt.setInt(4, toDo.getPriority().getValue());
            prepStmt.setString(5, toDo.getClassification().getString());
            prepStmt.setString(6, toDo.getStartDay());
            prepStmt.setString(7, toDo.getStartHour());
            prepStmt.setString(8, toDo.getEndDay());
            prepStmt.setString(9, toDo.getEndHour());
            prepStmt.setInt(10, toDo.getPercentCompleted());
            prepStmt.setString(11, toDo.getCompletedDay());
            prepStmt.setInt(12, toDo.getDuration());
            prepStmt.setString(13, toDo.getSpaceId());
            prepStmt.setString(14, toDo.getComponentId());
            prepStmt.setString(15, toDo.getExternalId());
            prepStmt.setInt(16, Integer.parseInt(toDo.getId()));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    static void removeToDo(String id) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)TO_DO_TABLE).where("id = ?", new Object[]{Integer.parseInt(id)}).execute();
    }

    static SilverpeasList<ToDoHeader> getNotCompletedToDoHeadersForUser(String userId) throws SQLException {
        return JdbcSqlQuery.select((String)"DISTINCT CalendarToDo.id, CalendarToDo.name, CalendarToDo.delegatorId, CalendarToDo.description, CalendarToDo.priority, CalendarToDo.classification, CalendarToDo.startDay, CalendarToDo.startHour, CalendarToDo.endDay, CalendarToDo.endHour, CalendarToDo.percentCompleted, CalendarToDo.completedDay, CalendarToDo.duration, CalendarToDo.spaceId, CalendarToDo.componentId, CalendarToDo.externalId, lower(name) ln").from(new String[]{TO_DO_TABLE}).join(TO_DO_ATTENDEE_TABLE).on(TO_DO_JOINING_TO_DO_ATTENDEE, new Object[0]).where(USER_ID_CRITERION, new Object[]{userId}).and("completedDay IS NULL", new Object[0]).orderBy(new String[]{ORDER_BY_CLAUSE}).execute(ToDoDAO::getToDoHeaderFromResultSet);
    }

    static SilverpeasList<ToDoHeader> getOrganizerToDoHeaders(String organizerId) throws SQLException {
        return JdbcSqlQuery.select((String)"CalendarToDo.id, CalendarToDo.name, CalendarToDo.delegatorId, CalendarToDo.description, CalendarToDo.priority, CalendarToDo.classification, CalendarToDo.startDay, CalendarToDo.startHour, CalendarToDo.endDay, CalendarToDo.endHour, CalendarToDo.percentCompleted, CalendarToDo.completedDay, CalendarToDo.duration, CalendarToDo.spaceId, CalendarToDo.componentId, CalendarToDo.externalId, lower(name) ln").from(new String[]{TO_DO_TABLE}).where("delegatorId = ?", new Object[]{organizerId}).and("completedDay IS NULL", new Object[0]).orderBy(new String[]{ORDER_BY_CLAUSE}).execute(ToDoDAO::getToDoHeaderFromResultSet);
    }

    static SilverpeasList<ToDoHeader> getClosedToDoHeaders(String organizerId) throws SQLException {
        return JdbcSqlQuery.select((String)"*").from(new String[]{"("}).addSqlPart("SELECT CalendarToDo.id, CalendarToDo.name, CalendarToDo.delegatorId, CalendarToDo.description, CalendarToDo.priority, CalendarToDo.classification, CalendarToDo.startDay, CalendarToDo.startHour, CalendarToDo.endDay, CalendarToDo.endHour, CalendarToDo.percentCompleted, CalendarToDo.completedDay, CalendarToDo.duration, CalendarToDo.spaceId, CalendarToDo.componentId, CalendarToDo.externalId, lower(name) ln", new Object[0]).from(new String[]{TO_DO_TABLE}).join(TO_DO_ATTENDEE_TABLE).on(TO_DO_JOINING_TO_DO_ATTENDEE, new Object[0]).where(USER_ID_CRITERION, new Object[]{organizerId}).and("completedDay IS NOT NULL", new Object[0]).union().addSqlPart("SELECT CalendarToDo.id, CalendarToDo.name, CalendarToDo.delegatorId, CalendarToDo.description, CalendarToDo.priority, CalendarToDo.classification, CalendarToDo.startDay, CalendarToDo.startHour, CalendarToDo.endDay, CalendarToDo.endHour, CalendarToDo.percentCompleted, CalendarToDo.completedDay, CalendarToDo.duration, CalendarToDo.spaceId, CalendarToDo.componentId, CalendarToDo.externalId, lower(name) ln", new Object[0]).from(new String[]{TO_DO_TABLE}).where("delegatorId = ?", new Object[]{organizerId}).and("completedDay IS NOT NULL", new Object[0]).addSqlPart(") u", new Object[0]).orderBy(new String[]{ORDER_BY_CLAUSE}).execute(ToDoDAO::getToDoHeaderFromResultSet);
    }

    static SilverpeasList<ToDoHeader> getToDoHeadersByExternalId(String componentId, String externalId) throws SQLException {
        return JdbcSqlQuery.select((String)"DISTINCT CalendarToDo.id, CalendarToDo.name, CalendarToDo.delegatorId, CalendarToDo.description, CalendarToDo.priority, CalendarToDo.classification, CalendarToDo.startDay, CalendarToDo.startHour, CalendarToDo.endDay, CalendarToDo.endHour, CalendarToDo.percentCompleted, CalendarToDo.completedDay, CalendarToDo.duration, CalendarToDo.spaceId, CalendarToDo.componentId, CalendarToDo.externalId, lower(name) ln").from(new String[]{TO_DO_TABLE}).where("componentId = ?", new Object[]{componentId}).and("externalId like ?", new Object[]{externalId}).orderBy(new String[]{"startDay, ln"}).execute(ToDoDAO::getToDoHeaderFromResultSet);
    }

    static SilverpeasList<ToDoHeader> getToDoHeadersByInstanceId(String componentId) throws SQLException {
        return JdbcSqlQuery.select((String)"CalendarToDo.id, CalendarToDo.name, CalendarToDo.delegatorId, CalendarToDo.description, CalendarToDo.priority, CalendarToDo.classification, CalendarToDo.startDay, CalendarToDo.startHour, CalendarToDo.endDay, CalendarToDo.endHour, CalendarToDo.percentCompleted, CalendarToDo.completedDay, CalendarToDo.duration, CalendarToDo.spaceId, CalendarToDo.componentId, CalendarToDo.externalId, lower(name) ln").from(new String[]{TO_DO_TABLE}).where("componentId = ?", new Object[]{componentId}).orderBy(new String[]{ORDER_BY_CLAUSE}).execute(ToDoDAO::getToDoHeaderFromResultSet);
    }

    static ToDoHeader getToDoHeaderFromResultSet(ResultSet rs) throws SQLException {
        try {
            int i = 1;
            String id = String.valueOf(rs.getInt(i++));
            String name = rs.getString(i++);
            String delegatorId = rs.getString(i++);
            ToDoHeader toDo = new ToDoHeader(id, name, delegatorId);
            toDo.setDescription(rs.getString(i++));
            toDo.getPriority().setValue(rs.getInt(i++));
            toDo.getClassification().setString(rs.getString(i++));
            toDo.setStartDay(rs.getString(i++));
            toDo.setStartHour(rs.getString(i++));
            toDo.setEndDay(rs.getString(i++));
            toDo.setEndHour(rs.getString(i++));
            toDo.setPercentCompleted(rs.getInt(i++));
            toDo.setCompletedDay(rs.getString(i++));
            toDo.setDuration(rs.getInt(i++));
            toDo.setSpaceId(rs.getString(i++));
            toDo.setComponentId(rs.getString(i++));
            toDo.setExternalId(rs.getString(i));
            return toDo;
        }
        catch (ParseException e) {
            SilverLogger.getLogger(ToDoDAO.class).warn((Throwable)e);
            return null;
        }
    }

    static ToDoHeader getToDoHeader(String toDoId) throws SQLException {
        return (ToDoHeader)JdbcSqlQuery.select((String)COLUMNNAMES).from(new String[]{TO_DO_TABLE}).where("id = ?", new Object[]{Integer.parseInt(toDoId)}).executeUnique(ToDoDAO::getToDoHeaderFromResultSet);
    }

    static SilverpeasList<String> getAllTodoByUser(String userId) throws SQLException {
        return JdbcSqlQuery.select((String)"DISTINCT (CalendarToDo.id)").from(new String[]{TO_DO_TABLE}).join(TO_DO_ATTENDEE_TABLE).on(TO_DO_JOINING_TO_DO_ATTENDEE, new Object[0]).where(USER_ID_CRITERION, new Object[]{userId}).execute(r -> r.getString(1));
    }
}

