/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.util.TriStatsConsumer;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.TimerStats;

public final class UpsertMetricUpdater {
    private final MeterStats createNodeUpsertMeter;
    private final MeterStats createSplitNodeMeter;
    private final TimerStats createNodeUpsertTimer;

    public UpsertMetricUpdater(MeterStats createNodeUpsertMeter, MeterStats createSplitNodeMeter, TimerStats createNodeUpsertTimer) {
        this.createNodeUpsertMeter = createNodeUpsertMeter;
        this.createSplitNodeMeter = createSplitNodeMeter;
        this.createNodeUpsertTimer = createNodeUpsertTimer;
    }

    public void update(Collection<? extends Document> collection, long timeTakenNanos, List<String> ids, BiPredicate<Collection<? extends Document>, Integer> isNodesCollectionUpdated, TriStatsConsumer upsertStatsConsumer) {
        Objects.requireNonNull(isNodesCollectionUpdated);
        Objects.requireNonNull(upsertStatsConsumer);
        if (isNodesCollectionUpdated.negate().test(collection, ids.size())) {
            return;
        }
        upsertStatsConsumer.accept(this.createNodeUpsertMeter, this.createSplitNodeMeter, this.createNodeUpsertTimer, ids, timeTakenNanos);
    }
}

