/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.docvalues;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueStr;

public abstract class DocTermsIndexDocValues
extends FunctionValues {
    protected final SortedDocValues termsIndex;
    protected final ValueSource vs;
    protected final MutableValueStr val = new MutableValueStr();
    protected final CharsRefBuilder spareChars = new CharsRefBuilder();
    private final String field;
    private int lastDocID;

    public DocTermsIndexDocValues(ValueSource vs, LeafReaderContext context, String field) throws IOException {
        this(field, vs, DocTermsIndexDocValues.open(context, field));
    }

    protected DocTermsIndexDocValues(String field, ValueSource vs, SortedDocValues termsIndex) {
        this.field = field;
        this.vs = vs;
        this.termsIndex = termsIndex;
    }

    protected int getOrdForDoc(int doc) throws IOException {
        if (doc < this.lastDocID) {
            throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + doc);
        }
        this.lastDocID = doc;
        int curDocID = this.termsIndex.docID();
        if (doc > curDocID) {
            curDocID = this.termsIndex.advance(doc);
        }
        if (doc == curDocID) {
            return this.termsIndex.ordValue();
        }
        return -1;
    }

    protected abstract String toTerm(String var1);

    @Override
    public boolean exists(int doc) throws IOException {
        return this.getOrdForDoc(doc) >= 0;
    }

    @Override
    public int ordVal(int doc) throws IOException {
        return this.getOrdForDoc(doc);
    }

    @Override
    public int numOrd() {
        return this.termsIndex.getValueCount();
    }

    @Override
    public boolean bytesVal(int doc, BytesRefBuilder target) throws IOException {
        target.clear();
        if (this.getOrdForDoc(doc) == -1) {
            return false;
        }
        target.copyBytes(this.termsIndex.binaryValue());
        return true;
    }

    @Override
    public String strVal(int doc) throws IOException {
        if (this.getOrdForDoc(doc) == -1) {
            return null;
        }
        BytesRef term = this.termsIndex.binaryValue();
        this.spareChars.copyUTF8Bytes(term);
        return this.spareChars.toString();
    }

    @Override
    public boolean boolVal(int doc) throws IOException {
        return this.exists(doc);
    }

    @Override
    public abstract Object objectVal(int var1) throws IOException;

    @Override
    public ValueSourceScorer getRangeScorer(final LeafReaderContext readerContext, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) throws IOException {
        lowerVal = lowerVal == null ? null : this.toTerm(lowerVal);
        upperVal = upperVal == null ? null : this.toTerm(upperVal);
        int lower = Integer.MIN_VALUE;
        if (lowerVal != null) {
            lower = this.termsIndex.lookupTerm(new BytesRef((CharSequence)lowerVal));
            if (lower < 0) {
                lower = -lower - 1;
            } else if (!includeLower) {
                ++lower;
            }
        }
        int upper = Integer.MAX_VALUE;
        if (upperVal != null) {
            upper = this.termsIndex.lookupTerm(new BytesRef((CharSequence)upperVal));
            if (upper < 0) {
                upper = -upper - 2;
            } else if (!includeUpper) {
                --upper;
            }
        }
        final int ll = lower;
        final int uu = upper;
        return new ValueSourceScorer(readerContext, this){
            final SortedDocValues values;
            private int lastDocID;
            {
                super(readerContext2, values);
                this.values = readerContext.reader().getSortedDocValues(DocTermsIndexDocValues.this.field);
            }

            @Override
            public boolean matches(int doc) throws IOException {
                if (doc < this.lastDocID) {
                    throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + doc);
                }
                if (doc > this.values.docID()) {
                    this.values.advance(doc);
                }
                if (doc == this.values.docID()) {
                    int ord = this.values.ordValue();
                    return ord >= ll && ord <= uu;
                }
                return false;
            }
        };
    }

    @Override
    public String toString(int doc) throws IOException {
        return this.vs.description() + '=' + this.strVal(doc);
    }

    @Override
    public FunctionValues.ValueFiller getValueFiller() {
        return new FunctionValues.ValueFiller(){
            private final MutableValueStr mval = new MutableValueStr();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc) throws IOException {
                int ord = DocTermsIndexDocValues.this.getOrdForDoc(doc);
                this.mval.value.clear();
                boolean bl = this.mval.exists = ord >= 0;
                if (this.mval.exists) {
                    this.mval.value.copyBytes(DocTermsIndexDocValues.this.termsIndex.lookupOrd(ord));
                }
            }
        };
    }

    static SortedDocValues open(LeafReaderContext context, String field) throws IOException {
        try {
            return DocValues.getSorted((LeafReader)context.reader(), (String)field);
        }
        catch (RuntimeException e) {
            throw new DocTermsIndexException(field, e);
        }
    }

    public static final class DocTermsIndexException
    extends RuntimeException {
        public DocTermsIndexException(String fieldName, RuntimeException cause) {
            super("Can't initialize DocTermsIndex to generate (function) FunctionValues for field: " + fieldName, cause);
        }
    }
}

