/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.notification;

import java.util.Optional;
import org.silverpeas.components.formsonline.model.FormInstance;
import org.silverpeas.components.formsonline.model.FormInstanceValidation;
import org.silverpeas.components.formsonline.model.FormInstanceValidationType;
import org.silverpeas.components.formsonline.notification.AbstractFormsOnlineProcessedRequestUserNotification;
import org.silverpeas.core.notification.user.client.constant.NotifAction;

public class FormsOnlineProcessedRequestUserNotification
extends AbstractFormsOnlineProcessedRequestUserNotification {
    public FormsOnlineProcessedRequestUserNotification(FormInstance resource, NotifAction action) {
        super(resource, action);
        Optional<FormInstanceValidationType> pendingValidation = Optional.ofNullable(resource.getPendingValidation()).filter(v -> NotifAction.VALIDATE == action).map(FormInstanceValidation::getValidationType);
        if (pendingValidation.filter(FormInstanceValidationType::isFinal).isPresent()) {
            this.setUserIdsToNotify(resource.getForm().getReceiversAsUsers());
            this.setGroupIdsToNotify(resource.getForm().getReceiversAsGroups());
        } else if (pendingValidation.filter(FormInstanceValidationType::isIntermediate).isPresent()) {
            this.setUserIdsToNotify(resource.getForm().getIntermediateReceiversAsUsers());
            this.setGroupIdsToNotify(resource.getForm().getIntermediateReceiversAsGroups());
        } else {
            this.setUserIdsToNotify(null);
            this.setGroupIdsToNotify(null);
        }
    }

    @Override
    protected String getBundleSubjectKey() {
        return "formsOnline.msgFormToValid";
    }

    @Override
    protected String getTemplateFileName() {
        return "notificationProcessed";
    }

    @Override
    protected int getCurrentValidationStep() {
        return super.getCurrentValidationStep() + 1;
    }
}

