/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.socialnetwork;

import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.components.gallery.model.InternalMedia;
import org.silverpeas.components.gallery.model.MediaWithStatus;
import org.silverpeas.core.socialnetwork.model.AbstractSocialInformation;
import org.silverpeas.core.socialnetwork.model.SocialInformationType;
import org.silverpeas.kernel.util.StringUtil;

public class SocialInformationGallery
extends AbstractSocialInformation {
    public SocialInformationGallery(MediaWithStatus picture) {
        super(picture.getMedia().getMediaPK().toResourceReference());
        this.setTitle(picture.getMedia().getTitle());
        this.setUpdated(picture.isUpdate());
        String description = picture.getMedia().getDescription();
        if (!StringUtil.isDefined((String)description)) {
            description = "";
        }
        this.setDescription(description);
        if (this.isUpdated()) {
            this.setAuthor(picture.getMedia().getLastUpdatedBy());
            this.setDate(picture.getMedia().getLastUpdateDate());
        } else {
            this.setAuthor(picture.getMedia().getCreatorId());
            this.setDate(picture.getMedia().getCreationDate());
        }
        this.setUrl("/Rgallery/" + picture.getMedia().getInstanceId() + "/" + picture.getMedia().getURL());
        String id = picture.getMedia().getId();
        String mimeType = "streaming";
        if (picture.getMedia() instanceof InternalMedia) {
            mimeType = ((InternalMedia)picture.getMedia()).getFileMimeType().getMimeType();
        }
        String icon = "/FileServer/" + id + "_preview.jpg?ComponentId=" + picture.getMedia().getInstanceId() + "&SourceFile=" + id + "_preview.jpg&MimeType=" + mimeType + "&Directory=image" + id;
        this.setIcon(icon);
        this.setType(SocialInformationType.MEDIA.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SocialInformationGallery)) {
            return false;
        }
        SocialInformationGallery other = (SocialInformationGallery)((Object)obj);
        if (this.type.toString() == null ? other.type.toString() != null : !this.type.toString().equals(other.type.toString())) {
            return false;
        }
        return this.url == null ? other.url == null : this.url.equals(other.url);
    }

    public int hashCode() {
        return new HashCodeBuilder(11, 19).append((Object)this.getType()).append((Object)this.getTitle()).append((Object)this.getDescription()).append((Object)this.getAuthor()).append((Object)this.getDate()).append((Object)this.getUrl()).toHashCode();
    }
}

