/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.service.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.components.mailinglist.model.MailingListRuntimeException;
import org.silverpeas.components.mailinglist.service.model.MailingListService;
import org.silverpeas.components.mailinglist.service.model.beans.ExternalUser;
import org.silverpeas.components.mailinglist.service.model.beans.InternalGroupSubscriber;
import org.silverpeas.components.mailinglist.service.model.beans.InternalSubscriber;
import org.silverpeas.components.mailinglist.service.model.beans.InternalUser;
import org.silverpeas.components.mailinglist.service.model.beans.InternalUserSubscriber;
import org.silverpeas.components.mailinglist.service.model.beans.MailingList;
import org.silverpeas.components.mailinglist.service.model.dao.MailingListDao;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;

@Service
@Transactional
public class MailingListServiceImpl
implements MailingListService {
    public static final String COMPONENT_NAME = "mailinglist";
    @Inject
    private MailingListDao mailingListDao;
    @Inject
    private OrganizationController organisationController;

    public MailingListDao getMailingListDao() {
        return this.mailingListDao;
    }

    public OrganizationController getOrganisationController() {
        return this.organisationController;
    }

    @Override
    public String createMailingList(MailingList mailingList) {
        String subscribedAddress = this.organisationController.getComponentParameterValue(mailingList.getComponentId(), "subscribedAddress");
        String componentId = mailingList.getComponentId();
        String[] ids = this.organisationController.getCompoId(COMPONENT_NAME);
        if (ids != null) {
            for (String id : ids) {
                String param;
                Object currentId = id;
                if (currentId != null && !((String)currentId).startsWith(COMPONENT_NAME)) {
                    currentId = COMPONENT_NAME + (String)currentId;
                }
                if (componentId.equalsIgnoreCase((String)currentId) || (param = this.organisationController.getComponentParameterValue(id, "subscribedAddress")) == null || !param.equalsIgnoreCase(subscribedAddress)) continue;
                throw new MailingListRuntimeException("MailingListServiceImpl", 4, "Address already subscribed");
            }
        }
        return this.mailingListDao.createMailingList(mailingList);
    }

    @Override
    public void addExternalUser(String componentId, ExternalUser user) {
        MailingList mailingList = this.mailingListDao.findByComponentId(componentId);
        if (mailingList != null) {
            mailingList.getExternalSubscribers().add(user);
            this.mailingListDao.updateMailingList(mailingList);
        }
    }

    @Override
    public void removeExternalUser(String componentId, ExternalUser user) {
        MailingList mailingList = this.mailingListDao.findByComponentId(componentId);
        if (mailingList != null) {
            mailingList.getExternalSubscribers().remove(user);
            this.mailingListDao.updateMailingList(mailingList);
        }
    }

    @Override
    public void deleteMailingList(String componentId) {
        MailingList mailingList = this.mailingListDao.findByComponentId(componentId);
        if (mailingList != null) {
            this.mailingListDao.deleteMailingList(mailingList);
        }
    }

    @Override
    public MailingList findMailingList(String componentId) {
        MailingList mailingList = this.mailingListDao.findByComponentId(componentId);
        if (mailingList == null) {
            return null;
        }
        this.fillMailingList(mailingList);
        return mailingList;
    }

    protected void fillMailingList(MailingList mailingList) {
        UserDetail[] details;
        String subscribedAddress = this.organisationController.getComponentParameterValue(mailingList.getComponentId(), "subscribedAddress");
        mailingList.setSubscribedAddress(subscribedAddress);
        ComponentInst component = this.organisationController.getComponentInst(mailingList.getComponentId());
        mailingList.setName(component.getLabel());
        mailingList.setDescription(component.getDescription());
        String moderated = this.organisationController.getComponentParameterValue(mailingList.getComponentId(), "moderated");
        mailingList.setModerated(this.getParamBooleanValue(moderated));
        String notify = this.organisationController.getComponentParameterValue(mailingList.getComponentId(), "notify");
        mailingList.setNotify(this.getParamBooleanValue(notify));
        String open = this.organisationController.getComponentParameterValue(mailingList.getComponentId(), "open");
        mailingList.setOpen(this.getParamBooleanValue(open));
        String rss = this.organisationController.getComponentParameterValue(mailingList.getComponentId(), "rss");
        mailingList.setSupportRSS(this.getParamBooleanValue(rss));
        for (UserDetail detail : details = (UserDetail[])this.organisationController.getAllUsers(mailingList.getComponentId())) {
            String[] roles;
            for (String role : roles = this.organisationController.getUserProfiles(detail.getId(), mailingList.getComponentId())) {
                InternalUser user;
                if ("reader".equals(role)) {
                    user = new InternalUser(detail.getId(), detail.getEmailAddress());
                    user.setDomain(this.organisationController.getDomain(detail.getDomainId()).getSilverpeasServerURL());
                    user.setName(detail.getDisplayedName());
                    user.setEmail(detail.getEmailAddress());
                    mailingList.getReaders().add(user);
                    continue;
                }
                if (!"moderator".equalsIgnoreCase(role) && !"admin".equalsIgnoreCase(role)) continue;
                user = new InternalUser(detail.getId(), detail.getEmailAddress());
                user.setDomain(this.organisationController.getDomain(detail.getDomainId()).getSilverpeasServerURL());
                user.setName(detail.getDisplayedName());
                user.setEmail(detail.getEmailAddress());
                mailingList.getModerators().add(user);
            }
        }
    }

    @Override
    public void addExternalUsers(String componentId, Collection<ExternalUser> users) {
        MailingList mailingList = this.mailingListDao.findByComponentId(componentId);
        if (mailingList != null) {
            for (ExternalUser user : users) {
                user.setComponentId(componentId);
                mailingList.getExternalSubscribers().add(user);
            }
            this.mailingListDao.updateMailingList(mailingList);
        }
    }

    @Override
    public void removeExternalUsers(String componentId, Collection<ExternalUser> users) {
        MailingList mailingList = this.mailingListDao.findByComponentId(componentId);
        if (mailingList != null) {
            for (ExternalUser user : users) {
                user.setComponentId(componentId);
                mailingList.getExternalSubscribers().remove(user);
            }
            this.mailingListDao.updateMailingList(mailingList);
        }
    }

    protected boolean getParamBooleanValue(String param) {
        return param != null && (Boolean.valueOf(param) != false || "Y".equalsIgnoreCase(param) || "YES".equalsIgnoreCase(param));
    }

    @Override
    public List<MailingList> listAllMailingLists() {
        List<MailingList> lists = this.mailingListDao.listMailingLists();
        for (MailingList mailingList : lists) {
            this.fillMailingList(mailingList);
        }
        return lists;
    }

    @Override
    public void setInternalSubscribers(String componentId, Collection<String> userIds) {
        MailingList mailingList = this.mailingListDao.findByComponentId(componentId);
        if (mailingList != null) {
            Map<String, InternalSubscriber> subscribers = this.prepareMap(mailingList.getInternalSubscribers());
            mailingList.getInternalSubscribers().clear();
            if (userIds != null && !userIds.isEmpty()) {
                HashSet<InternalUserSubscriber> newUsers = new HashSet<InternalUserSubscriber>(userIds.size());
                for (String userId : userIds) {
                    InternalUserSubscriber user = (InternalUserSubscriber)subscribers.get(userId);
                    if (user == null) {
                        user = new InternalUserSubscriber();
                        user.setExternalId(userId);
                    }
                    newUsers.add(user);
                }
                mailingList.getInternalSubscribers().addAll(newUsers);
            } else {
                mailingList.getInternalSubscribers().clear();
            }
            this.mailingListDao.updateMailingList(mailingList);
        }
    }

    @Override
    public void setGroupSubscribers(String componentId, Collection<String> groupIds) {
        MailingList mailingList = this.mailingListDao.findByComponentId(componentId);
        if (mailingList != null) {
            Map<String, InternalSubscriber> groups = this.prepareMap(mailingList.getGroupSubscribers());
            mailingList.getGroupSubscribers().clear();
            if (groupIds != null && !groupIds.isEmpty()) {
                HashSet<InternalGroupSubscriber> newGroups = new HashSet<InternalGroupSubscriber>(groupIds.size());
                for (String groupId : groupIds) {
                    InternalGroupSubscriber group = (InternalGroupSubscriber)groups.get(groupId);
                    if (group == null) {
                        group = new InternalGroupSubscriber();
                        group.setExternalId(groupId);
                    }
                    newGroups.add(group);
                }
                mailingList.getGroupSubscribers().addAll(newGroups);
            } else {
                mailingList.getGroupSubscribers().clear();
            }
            this.mailingListDao.updateMailingList(mailingList);
        }
    }

    @Override
    public void subscribe(String componentId, String userId) {
        MailingList mailingList = this.mailingListDao.findByComponentId(componentId);
        if (mailingList != null) {
            InternalUserSubscriber user = new InternalUserSubscriber();
            user.setExternalId(userId);
            mailingList.getInternalSubscribers().add(user);
            this.mailingListDao.updateMailingList(mailingList);
        }
    }

    @Override
    public void unsubscribe(String componentId, String userId) {
        MailingList mailingList = this.mailingListDao.findByComponentId(componentId);
        if (mailingList != null && userId != null) {
            Iterator<InternalUserSubscriber> iter = mailingList.getInternalSubscribers().iterator();
            while (iter.hasNext()) {
                InternalUserSubscriber user = iter.next();
                if (!userId.equalsIgnoreCase(user.getExternalId())) continue;
                iter.remove();
            }
            this.mailingListDao.updateMailingList(mailingList);
        }
    }

    private Map<String, InternalSubscriber> prepareMap(Set<? extends InternalSubscriber> subscribers) {
        HashMap<String, InternalSubscriber> result = new HashMap<String, InternalSubscriber>(subscribers.size());
        for (InternalSubscriber internalSubscriber : subscribers) {
            result.put(internalSubscriber.getExternalId(), internalSubscriber);
        }
        return result;
    }
}

