/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.jdbcconnector.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.sql.DataSource;
import javax.validation.constraints.NotNull;
import org.silverpeas.components.jdbcconnector.service.DataSourceConnectionInfoService;
import org.silverpeas.components.jdbcconnector.service.JdbcConnectorException;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueIntegerIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@NamedQueries(value={@NamedQuery(name="DataSourceConnectionInfo.findByInstanceId", query="from DataSourceConnectionInfo where instanceId = :instanceId"), @NamedQuery(name="DataSourceConnectionInfo.deleteByInstanceId", query="delete DataSourceConnectionInfo where instanceId = :instanceId")})
@Table(name="sc_connecteurjdbc_connectinfo")
public class DataSourceConnectionInfo
extends BasicJpaEntity<DataSourceConnectionInfo, UniqueIntegerIdentifier> {
    @Column(length=250, nullable=false)
    @NotNull
    private String dataSource;
    @Column(length=250)
    private String login;
    @Column(length=250)
    private String password;
    @Column(length=4000)
    private String sqlreq;
    private int rowLimit = 0;
    @Column(length=50, nullable=false)
    @NotNull
    private String instanceId;

    public static DataSourceConnectionInfo getById(String id) {
        return DataSourceConnectionInfoService.get().getConnectionInfo(id);
    }

    public static List<DataSourceConnectionInfo> getFromComponentInstance(String instanceId) {
        return DataSourceConnectionInfoService.get().getConnectionInfoList(instanceId);
    }

    public static void removeFromComponentInstance(String instanceId) {
        DataSourceConnectionInfoService.get().removeConnectionInfoOfComponentInstance(instanceId);
    }

    protected DataSourceConnectionInfo() {
    }

    public DataSourceConnectionInfo(String dataSource, String instanceId) {
        this.dataSource = dataSource;
        this.instanceId = instanceId;
    }

    public boolean isDefined() {
        return StringUtil.isDefined((String)this.dataSource) && StringUtil.isDefined((String)this.instanceId);
    }

    public DataSourceConnectionInfo withSqlRequest(String sqlRequest) {
        this.setSqlRequest(sqlRequest);
        return this;
    }

    public DataSourceConnectionInfo withDataMaxNumber(int maxNumber) {
        this.setDataMaxNumber(maxNumber);
        return this;
    }

    public DataSourceConnectionInfo withLoginAndPassword(String login, String password) {
        this.setLoginAndPassword(login, password);
        return this;
    }

    public DataSourceConnectionInfo withDataSourceName(String dataSourceName) {
        this.setDataSourceName(dataSourceName);
        return this;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getLogin() {
        return this.login == null ? "" : this.login;
    }

    public String getPassword() {
        return this.password == null ? "" : this.password;
    }

    public String getSqlRequest() {
        return this.sqlreq;
    }

    public int getDataMaxNumber() {
        return this.rowLimit;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSource = dataSourceName;
    }

    public void setLoginAndPassword(String login, String password) {
        this.login = login;
        this.password = password;
    }

    public void setSqlRequest(String sqlRequest) {
        this.sqlreq = sqlRequest;
    }

    public void setDataMaxNumber(int maxNumber) {
        this.rowLimit = maxNumber <= 0 ? 0 : maxNumber;
    }

    public void save() {
        DataSourceConnectionInfoService.get().saveConnectionInfo(this);
    }

    public void remove() {
        DataSourceConnectionInfoService.get().removeConnectionInfo(this);
    }

    public Connection openConnection() throws JdbcConnectorException {
        try {
            DataSource ds = (DataSource)InitialContext.doLookup(this.getDataSourceName());
            return ds.getConnection(this.getLogin(), this.getPassword());
        }
        catch (SQLException | NamingException ex) {
            throw new JdbcConnectorException(ex.getMessage(), new String[0]);
        }
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

