/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.notification;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.silverpeas.components.formsonline.model.FormInstance;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.ContributionValidation;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.URLUtil;

public abstract class AbstractFormsOnlineRequestUserNotification
extends AbstractTemplateUserNotificationBuilder<FormInstance> {
    private final NotifAction action;
    private final String senderName;

    protected AbstractFormsOnlineRequestUserNotification(FormInstance resource, NotifAction action) {
        super((Object)resource);
        this.action = action;
        Supplier<String> creatorDisplayName = () -> User.getById((String)resource.getCreatorId()).getDisplayedName();
        this.senderName = NotifAction.PENDING_VALIDATION.equals((Object)action) || NotifAction.CANCELED.equals((Object)action) ? creatorDisplayName.get() : this.getLatestRequestValidator().map(User::getDisplayedName).orElseGet(creatorDisplayName);
    }

    protected String getLocalizationBundlePath() {
        return "org.silverpeas.formsonline.multilang.formsOnlineBundle";
    }

    protected String getTemplatePath() {
        return "formsonline";
    }

    protected void performTemplateData(String language, FormInstance resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, this.getTitle(language), "");
        template.setAttribute("form", (Object)resource.getForm());
        template.setAttribute("request", (Object)resource);
        template.setAttribute("formName", (Object)resource.getForm().getName());
        template.setAttribute("senderName", (Object)this.getSenderName());
        template.setAttribute("requester", (Object)resource.getCreator());
        template.setAttribute("validator", (Object)resource.getValidator());
        template.setAttribute("pendingValidation", (Object)resource.getPendingValidation());
    }

    protected void performNotificationResource(String language, FormInstance resource, NotificationResourceData notificationResourceData) {
    }

    protected String getResourceURL(FormInstance resource) {
        return URLUtil.getComponentInstanceURL((String)resource.getComponentInstanceId()) + "/ViewRequest?Id=" + resource.getId();
    }

    protected String getSenderName() {
        return this.senderName;
    }

    protected NotifAction getAction() {
        return this.action;
    }

    protected String getComponentInstanceId() {
        return ((FormInstance)this.getResource()).getComponentInstanceId();
    }

    protected String getSender() {
        Supplier<String> creatorIdSupplier = () -> ((FormInstance)this.getResource()).getCreatorId();
        if (NotifAction.PENDING_VALIDATION.equals((Object)this.action) || NotifAction.CANCELED.equals((Object)this.action)) {
            return creatorIdSupplier.get();
        }
        return this.getLatestRequestValidator().map(User::getId).orElseGet(creatorIdSupplier);
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "formsOnline.notifLinkLabel";
    }

    protected boolean isSendImmediately() {
        return true;
    }

    protected Optional<User> getLatestRequestValidator() {
        return ((FormInstance)this.getResource()).getValidations().getLatestValidation().map(ContributionValidation::getValidator);
    }

    protected List<String> extractGroupIds(List<Group> groups) {
        return groups.stream().map(Group::getId).collect(Collectors.toList());
    }

    protected List<String> extractUserIds(List<User> users) {
        return users.stream().map(User::getId).collect(Collectors.toList());
    }
}

