/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.calendar.model;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.calendar.model.HolidayDetail;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class HolidaysDAO {
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
    private static final String AGENDA_HOLIDAYS_TABLENAME = "sb_agenda_holidays";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHolidayDate(Connection con, HolidayDetail holiday) throws SQLException, UtilException {
        SilverTrace.info((String)"calendar", (String)"HolidaysDAO.addHolidayDate()", (String)"root.MSG_GEN_ENTER_METHOD", (String)holiday.getDate().toString());
        if (!HolidaysDAO.isHolidayDate(con, holiday)) {
            StringBuffer insertStatement = new StringBuffer(128);
            insertStatement.append("insert into ").append(AGENDA_HOLIDAYS_TABLENAME);
            insertStatement.append(" values ( ? , ? )");
            PreparedStatement prepStmt = null;
            try {
                prepStmt = con.prepareStatement(insertStatement.toString());
                prepStmt.setInt(1, new Integer(holiday.getUserId()));
                prepStmt.setString(2, formatter.format(holiday.getDate()));
                prepStmt.executeUpdate();
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                throw throwable;
            }
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHolidayDate(Connection con, HolidayDetail holiday) throws SQLException {
        StringBuffer deleteStatement = new StringBuffer(128);
        deleteStatement.append("delete from ").append(AGENDA_HOLIDAYS_TABLENAME);
        deleteStatement.append(" where holidayDate = ? ");
        deleteStatement.append(" and userId = ? ");
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(deleteStatement.toString());
            prepStmt.setString(1, DateUtil.date2SQLDate((Date)holiday.getDate()));
            prepStmt.setInt(2, new Integer(holiday.getUserId()));
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHolidayDate(Connection con, HolidayDetail holiday) throws SQLException {
        boolean bl;
        StringBuffer query = new StringBuffer(128);
        query.append("select * ");
        query.append("from ").append(AGENDA_HOLIDAYS_TABLENAME);
        query.append(" where holidayDate = ? ");
        query.append(" and userId = ? ");
        SilverTrace.info((String)"calendar", (String)"HolidaysDAO.isHolidayDate()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("date = " + holiday.getDate().toString()));
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(query.toString());
            stmt.setString(1, DateUtil.date2SQLDate((Date)holiday.getDate()));
            stmt.setInt(2, new Integer(holiday.getUserId()));
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getHolidayDates(Connection con, String userId) throws SQLException {
        ArrayList<String> holidayDates = new ArrayList<String>();
        StringBuffer query = new StringBuffer(128);
        query.append("select * ");
        query.append("from ").append(AGENDA_HOLIDAYS_TABLENAME);
        query.append(" where userId = ? ");
        query.append("order by holidayDate ASC");
        SilverTrace.info((String)"calendar", (String)"HolidaysDAO.getHolidayDates()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("userId = " + userId));
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(query.toString());
            stmt.setInt(1, new Integer(userId));
            rs = stmt.executeQuery();
            while (rs.next()) {
                holidayDates.add(rs.getString("holidayDate"));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return holidayDates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getHolidayDates(Connection con, String userId, Date beginDate, Date endDate) throws SQLException {
        ArrayList<String> holidayDates = new ArrayList<String>();
        StringBuffer query = new StringBuffer(128);
        query.append("select * ");
        query.append("from ").append(AGENDA_HOLIDAYS_TABLENAME);
        query.append(" where userId = ? ");
        query.append(" and ? <= holidayDate ");
        query.append(" and holidayDate <= ? ");
        query.append("order by holidayDate ASC");
        SilverTrace.info((String)"calendar", (String)"HolidaysDAO.getHolidayDates()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("userId = " + userId + ", beginDate=" + beginDate.toString() + ", endDate=" + endDate.toString()));
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(query.toString());
            stmt.setInt(1, new Integer(userId));
            stmt.setString(2, DateUtil.date2SQLDate((Date)beginDate));
            stmt.setString(3, DateUtil.date2SQLDate((Date)endDate));
            rs = stmt.executeQuery();
            while (rs.next()) {
                holidayDates.add(rs.getString("holidayDate"));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return holidayDates;
    }
}

