/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.importCalendar.importOutlook;

import com.jacob.com.ComThread;
import com.silverpeas.importCalendar.AppletDrawer;
import com.silverpeas.importCalendar.JournalHeadersListFactory;
import com.silverpeas.importCalendar.ServletConnector;
import com.silverpeas.importCalendar.importOutlook.OutlookSecurityManager;
import com.silverpeas.importCalendar.importOutlook.SilverOutlookEventsList;
import java.applet.Applet;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class AppletImportEvents
extends Applet {
    private static final long serialVersionUID = 1L;
    private JournalHeadersListFactory journalList = null;
    private AppletDrawer appletDrawer = null;
    private ServletConnector servletConnector = null;
    private int nbDaysBefore = 7;

    @Override
    public String getAppletInfo() {
        return "Applet d'import de rendez-vous de Outlook vers Silverpeas";
    }

    @Override
    public void init() {
        super.init();
        try {
            this.initLibrary();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.journalList = new JournalHeadersListFactory(this.getParameter("SESSIONID"));
        this.appletDrawer = new AppletDrawer();
        this.servletConnector = new ServletConnector(this.getParameter("SERVLETURL"));
        String paramDaysBefore = this.getParameter("NBDAYSBEFORE");
        if (paramDaysBefore != null) {
            this.nbDaysBefore = Integer.parseInt(this.getParameter("NBDAYSBEFORE"));
        }
    }

    private void initLibrary() throws IOException {
        File tempJacobDll = File.createTempFile("jacob", ".dll");
        tempJacobDll.deleteOnExit();
        InputStream dllStream = AppletImportEvents.class.getClassLoader().getResourceAsStream("jacob.dll");
        FileOutputStream fileStream = new FileOutputStream(tempJacobDll);
        this.copy(dllStream, fileStream);
        dllStream.close();
        fileStream.close();
        System.setProperty("jacob.dll.path", tempJacobDll.getAbsolutePath());
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int read = 0;
        byte[] buf = new byte[1024];
        while (in.available() > 0 && (read = in.read(buf)) > 0) {
            out.write(buf, 0, read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        try {
            super.start();
            this.appletDrawer.initApplet(this, "Silverpeas : synchronization Outlook en cours\n");
            SilverOutlookEventsList myEvents = new SilverOutlookEventsList();
            myEvents.initWithCurrentOutlook();
            myEvents.loadItemsList(this.nbDaysBefore);
            boolean isOutlookSecurityManagerAvailable = true;
            OutlookSecurityManager securityManager = null;
            try {
                securityManager = new OutlookSecurityManager(myEvents.getOOutlook());
            }
            catch (Exception e) {
                isOutlookSecurityManagerAvailable = false;
            }
            if (isOutlookSecurityManagerAvailable) {
                securityManager.setSecurityWarningsEnabled(false);
            }
            List headers = this.journalList.buildJournalHeadersList(myEvents);
            if (isOutlookSecurityManagerAvailable) {
                securityManager.setSecurityWarningsEnabled(true);
            }
            String report = this.servletConnector.sendHeaders(headers);
            this.appletDrawer.addMessage(report);
            this.appletDrawer.addMessage("Synchronisation termin\u00e9e");
            if (!report.equals("")) {
                this.appletDrawer.showDialog();
            }
        }
        finally {
            ComThread.Release();
            new File(System.getProperty("jacob.dll.path")).delete();
        }
    }
}

