#!/usr/bin/env bash

usage() {
  echo """
Usage: $0 [-debug] SOURCE DESTINATION
 
Description:
       Upgrade a Jackrabbit JCR repository to a Oak JCR repository.
       The whole content, versions and binaries are copied to the new 
       repository.
       The new repository will be backed by a segment storage.

-debug
       The tool is running in debug mode with JDPD listening at port 5005.

SOURCE 
       The path to the Jackrabbit JCR home directory. The directory should
       contain the repository directory and the repository.xml file.
       For example: /opt/silverpeas/data/jcr.

DESTINATION
       The path to the Oak repository directory. If it doens't exist, it will
       be created. 
"""
}

if [ $# -lt 2 ] || [ $# -gt 3 ]; then
  usage
  exit 2
fi

if [ $# -eq 3 ]; then
  if [ "$1" = "-debug" ]; then
    debug="-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=*:5005"
    shift
  else
    echo "Unknown option: $1"
    usage
    exit 2
  fi
fi

prog_dir=`dirname $0`
jackrabbit_jcr="$1"
oak_jcr="$2"

if [ -d "$oak_jcr" ]; then
  mkdir -p "$oak_jcr"
fi

sed -i -e 's/^=\(\s\)*$/.empty.key=/g' "$jackrabbit_jcr/repository/namespaces/ns_reg.properties"

for f in $(ls "$prog_dir/lib"); do
  classpath="$classpath:$prog_dir/lib/$f"
done
classpath=${classpath#:}

java -cp "$classpath" ${debug} \
	org.apache.jackrabbit.oak.upgrade.cli.OakUpgrade \
	--copy-binaries "$jackrabbit_jcr" "$oak_jcr"
