/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.util.OracleEnvironment;
import oracle.net.jdbc.nl.NLException;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.SdpNTAdapter;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TcpsNTAdapter;
import oracle.net.nt.adapter.BequeathAdapter;

public class ConnOption {
    public NTAdapter nt;
    public String protocol;
    public String host;
    public int port;
    public String addr;
    public String sid;
    public String service_name;
    public String instance_name;
    public int delayBetweenRetry;
    public int tdu;
    public int sdu;
    public String httpsProxy;
    public int httpsProxyPort;
    public InetSocketAddress inetSocketAddress;
    public StringBuilder conn_data = new StringBuilder(200);
    public String sslServerCertDN;
    public String sslServerDNMatch;
    public String sslAllowWeakDNMatch;
    public String walletDirectory;
    public String webSocketUri = null;
    public Map<String, String> serverProcessEnvironmentVars = new HashMap<String, String>();
    public String serverProcessArguments = null;
    private ConnOption originalConnOption;
    public boolean done;
    public int connectTimeout;
    public int transportConnectTimeout;

    private NTAdapter getNT(@Blind(value=PropertiesBlinder.class) Properties socketOptions, SSLContext sslContext, Diagnosable diagnosable) throws NetException {
        block12: {
            try {
                if (this.protocol.equalsIgnoreCase("tcp")) {
                    this.nt = new TcpNTAdapter(this.addr, socketOptions, diagnosable, this);
                    break block12;
                }
                if (this.protocol.equalsIgnoreCase("tcps") || this.protocol.equalsIgnoreCase("wss")) {
                    this.nt = new TcpsNTAdapter(this.addr, socketOptions, sslContext, diagnosable, this);
                    break block12;
                }
                if (this.protocol.equalsIgnoreCase("sdp")) {
                    this.nt = new SdpNTAdapter(this.addr, this, socketOptions);
                    break block12;
                }
                if (this.protocol.equalsIgnoreCase("exadirect") || this.protocol.equalsIgnoreCase("msgqlt")) {
                    this.nt = new MQLNTAdapter(this.addr, this, socketOptions);
                    break block12;
                }
                if (this.protocol.equalsIgnoreCase("beq")) {
                    String SIDToBeUsed = this.sid;
                    if (SIDToBeUsed == null && (SIDToBeUsed = this.serverProcessEnvironmentVars.get(OracleEnvironment.SID.getEnvName())) == null) {
                        SIDToBeUsed = System.getenv(OracleEnvironment.SID.getEnvName());
                    }
                    if (SIDToBeUsed == null) {
                        throw new IllegalStateException(OracleEnvironment.SID.getEnvName() + " must be defined");
                    }
                    String oHome = this.serverProcessEnvironmentVars.get(OracleEnvironment.ORACLE_HOME.getEnvName());
                    if (oHome == null) {
                        oHome = System.getenv(OracleEnvironment.ORACLE_HOME.getEnvName());
                    }
                    if (oHome == null) {
                        throw new IllegalStateException(OracleEnvironment.ORACLE_HOME.getEnvName() + " must be defined");
                    }
                    BequeathAdapter beqNt = new BequeathAdapter(SIDToBeUsed, oHome, this.serverProcessArguments, socketOptions);
                    beqNt.setAdapterEnvironment(this.serverProcessEnvironmentVars);
                    this.nt = beqNt;
                    break block12;
                }
                throw new NetException(17821, "protocol: " + this.protocol);
            }
            catch (NLException nle) {
                throw new NetException(18951);
            }
            catch (Exception ex) {
                throw (NetException)new NetException(17821).initCause(ex);
            }
        }
        return this.nt;
    }

    public void connect(@Blind(value=PropertiesBlinder.class) Properties socketOptions, DMSFactory.DMSNoun dmsParent, Diagnosable diagnosable) throws IOException, InterruptedIOException {
        this.connect(socketOptions, dmsParent, null, diagnosable);
    }

    public void connect(@Blind(value=PropertiesBlinder.class) Properties socketOptions, DMSFactory.DMSNoun dmsParent, SSLContext sslContext, Diagnosable diagnosable) throws IOException, InterruptedIOException {
        if (this.nt == null) {
            this.nt = this.getNT(socketOptions, sslContext, diagnosable);
        }
        this.nt.connect(dmsParent);
    }

    final CompletionStage<Void> connectAsync(Properties socketOptions, DMSFactory.DMSNoun dmsParent, SSLContext sslContext, AsyncOutboundTimeoutHandler outboundTimeout, Executor asyncExecutor, Diagnosable diagnosable) {
        try {
            if (this.nt == null) {
                this.nt = this.getNT(socketOptions, sslContext, diagnosable);
            }
            return this.nt.connectAsync(dmsParent, outboundTimeout, asyncExecutor);
        }
        catch (IOException getNTFailure) {
            return CompletionStageUtil.failedStage(getNTFailure);
        }
    }

    public ConnOption getOriginalConnOption() {
        return this.originalConnOption == null ? this : this.originalConnOption;
    }

    public void setOriginalConnOption(ConnOption connOption) {
        this.originalConnOption = connOption;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        if (this.host != null) {
            stringBuilder.append("host=").append(this.host).append(" ");
        }
        if (this.port > 0) {
            stringBuilder.append("port=").append(this.port).append(" ");
        }
        if (this.sid != null) {
            stringBuilder.append("sid=").append(this.sid).append(" ");
        }
        if (this.protocol != null) {
            stringBuilder.append("protocol=").append(this.protocol).append(" ");
        }
        if (this.service_name != null) {
            stringBuilder.append("service_name=").append(this.service_name).append(" ");
        }
        if (this.addr != null) {
            stringBuilder.append("addr=").append(this.addr).append(" ");
        }
        if (this.conn_data != null) {
            stringBuilder.append("conn_data=").append((CharSequence)this.conn_data).append(" ");
        }
        if (this.sslServerCertDN != null) {
            stringBuilder.append("sslServerCertDN=").append(this.sslServerCertDN).append(" ");
        }
        stringBuilder.append("done=").append(this.done).append("]");
        return stringBuilder.toString();
    }

    boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.nt.isConnectionSocketKeepAlive();
    }
}

