/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.app;

import io.smallrye.metrics.app.Clock;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.microprofile.metrics.SimpleTimer;

public class SimpleTimerImpl
implements SimpleTimer {
    private final Clock clock;
    private final LongAdder count;
    private final LongAdder elapsedTime;
    private final AtomicReference<Duration> max_previousMinute;
    private final AtomicReference<Duration> min_previousMinute;
    private final AtomicReference<Duration> max_thisMinute;
    private final AtomicReference<Duration> min_thisMinute;
    private final AtomicLong thisMinute;

    public SimpleTimerImpl() {
        this(Clock.defaultClock());
    }

    public SimpleTimerImpl(Clock clock) {
        this.clock = clock;
        this.count = new LongAdder();
        this.elapsedTime = new LongAdder();
        this.thisMinute = new AtomicLong(this.getCurrentMinuteFromSystem());
        this.max_previousMinute = new AtomicReference<Object>(null);
        this.min_previousMinute = new AtomicReference<Object>(null);
        this.max_thisMinute = new AtomicReference<Object>(null);
        this.min_thisMinute = new AtomicReference<Object>(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Duration duration) {
        if (duration.compareTo(Duration.ZERO) > 0) {
            this.maybeStartNewMinute();
            SimpleTimerImpl simpleTimerImpl = this;
            synchronized (simpleTimerImpl) {
                Duration currentMin;
                this.count.increment();
                this.elapsedTime.add(duration.toNanos());
                Duration currentMax = this.max_thisMinute.get();
                if (currentMax == null || duration.compareTo(currentMax) > 0) {
                    this.max_thisMinute.set(duration);
                }
                if ((currentMin = this.min_thisMinute.get()) == null || duration.compareTo(currentMin) < 0) {
                    this.min_thisMinute.set(duration);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(Duration.ofNanos(this.clock.getTick() - startTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void time(Runnable event) {
        long startTime = this.clock.getTick();
        try {
            event.run();
        }
        finally {
            this.update(Duration.ofNanos(this.clock.getTick() - startTime));
        }
    }

    public Context time() {
        return new Context(this, this.clock);
    }

    public long getCount() {
        return this.count.sum();
    }

    public Duration getElapsedTime() {
        return Duration.ofNanos(this.elapsedTime.sum());
    }

    public Duration getMaxTimeDuration() {
        this.maybeStartNewMinute();
        return this.max_previousMinute.get();
    }

    public Duration getMinTimeDuration() {
        this.maybeStartNewMinute();
        return this.min_previousMinute.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeStartNewMinute() {
        long newMinute = this.getCurrentMinuteFromSystem();
        if (newMinute > this.thisMinute.get()) {
            SimpleTimerImpl simpleTimerImpl = this;
            synchronized (simpleTimerImpl) {
                if (newMinute > this.thisMinute.get()) {
                    this.thisMinute.set(newMinute);
                    this.max_previousMinute.set(this.max_thisMinute.get());
                    this.min_previousMinute.set(this.min_thisMinute.get());
                    this.max_thisMinute.set(null);
                    this.min_thisMinute.set(null);
                }
            }
        }
    }

    private long getCurrentMinuteFromSystem() {
        return System.currentTimeMillis() / 60000L;
    }

    public static class Context
    implements SimpleTimer.Context {
        private final SimpleTimerImpl timer;
        private final Clock clock;
        private final long startTime;

        private Context(SimpleTimerImpl timer, Clock clock) {
            this.timer = timer;
            this.clock = clock;
            this.startTime = clock.getTick();
        }

        public long stop() {
            long elapsed = this.clock.getTick() - this.startTime;
            this.timer.update(Duration.ofNanos(elapsed));
            return elapsed;
        }

        public void close() {
            this.stop();
        }
    }
}

