/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import javax.jms.IllegalStateException;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="AMQ")
public interface ActiveMQRALogger
extends BasicLogger {
    public static final ActiveMQRALogger LOGGER = (ActiveMQRALogger)Logger.getMessageLogger(ActiveMQRALogger.class, (String)ActiveMQRALogger.class.getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=151000, value="awaiting topic/queue creation {0}", format=Message.Format.MESSAGE_FORMAT)
    public void awaitingTopicQueueCreation(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=151001, value="Attempting to reconnect {0}", format=Message.Format.MESSAGE_FORMAT)
    public void attemptingReconnect(ActiveMQActivationSpec var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=151002, value="Reconnected with broker", format=Message.Format.MESSAGE_FORMAT)
    public void reconnected();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=151003, value="resource adaptor stopped", format=Message.Format.MESSAGE_FORMAT)
    public void raStopped();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=151004, value="Instantiating {0} \"{1}\" directly since UseJNDI=false.", format=Message.Format.MESSAGE_FORMAT)
    public void instantiatingDestination(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=151005, value="awaiting server availability", format=Message.Format.MESSAGE_FORMAT)
    public void awaitingJMSServerCreation();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=151006, value="Cluster topology change detected. Re-balancing connections on even {0}.", format=Message.Format.MESSAGE_FORMAT)
    public void rebalancingConnections(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=151007, value="Resource adaptor started", format=Message.Format.MESSAGE_FORMAT)
    public void resourceAdaptorStarted();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152001, value="problem resetting xa session after failure", format=Message.Format.MESSAGE_FORMAT)
    public void problemResettingXASession(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152002, value="Unable to roll local transaction back", format=Message.Format.MESSAGE_FORMAT)
    public void unableToRollbackTX();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152003, value="unable to reset session after failure, we will place the MDB Inflow now in setup mode for activation={0}", format=Message.Format.MESSAGE_FORMAT)
    public void unableToResetSession(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152004, value="Handling JMS exception failure", format=Message.Format.MESSAGE_FORMAT)
    public void handlingJMSFailure(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152005, value="Failure in broker activation {0}", format=Message.Format.MESSAGE_FORMAT)
    public void failureInActivation(@Cause Throwable var1, ActiveMQActivationSpec var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152006, value="Unable to call after delivery", format=Message.Format.MESSAGE_FORMAT)
    public void unableToCallAfterDelivery(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152007, value="Thread {0} could not be finished", format=Message.Format.MESSAGE_FORMAT)
    public void threadCouldNotFinish(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152008, value="Error interrupting handler on endpoint {0} handler = {1}", format=Message.Format.MESSAGE_FORMAT)
    public void errorInterruptingHandler(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152009, value="Unable to validate properties", format=Message.Format.MESSAGE_FORMAT)
    public void unableToValidateProperties(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152010, value="Unable to clear the transaction", format=Message.Format.MESSAGE_FORMAT)
    public void unableToClearTheTransaction(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152011, value="Unable to close the factory", format=Message.Format.MESSAGE_FORMAT)
    public void unableToCloseFactory(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=154000, value="Error while creating object Reference.", format=Message.Format.MESSAGE_FORMAT)
    public void errorCreatingReference(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=154001, value="Unable to stop resource adapter.", format=Message.Format.MESSAGE_FORMAT)
    public void errorStoppingRA(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=154003, value="Unable to reconnect {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorReconnecting(@Cause Throwable var1, ActiveMQActivationSpec var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=154004, value="Failed to deliver message", format=Message.Format.MESSAGE_FORMAT)
    public void errorDeliveringMessage(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=153001, value="using different ActiveMQRAConnectionFactory", format=Message.Format.MESSAGE_FORMAT)
    public void warnDifferentConnectionfactory();

    @Message(id=153002, value="Cannot create a subscriber on the durable subscription since it already has subscriber(s)")
    public IllegalStateException canNotCreatedNonSharedSubscriber();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=153003, value="Unsupported acknowledgement mode {0}", format=Message.Format.MESSAGE_FORMAT)
    public void invalidAcknowledgementMode(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=153004, value="Invalid number of session (negative) {0}, defaulting to {1}.", format=Message.Format.MESSAGE_FORMAT)
    public void invalidNumberOfMaxSession(int var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=153005, value="Unable to retrieve \"{0}\" from JNDI. Creating a new \"{1}\" named \"{2}\" to be used by the MDB.", format=Message.Format.MESSAGE_FORMAT)
    public void unableToRetrieveDestinationName(String var1, String var2, String var3);
}

