/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.opentracing.smallrye;

import io.opentracing.Tracer;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.wildfly.microprofile.opentracing.smallrye.TracingLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class TracingCDIExtension
implements Extension {
    private static final Map<ClassLoader, Tracer> TRACERS = Collections.synchronizedMap(new WeakHashMap());

    public static void registerApplicationTracer(ClassLoader classLoader, Tracer tracerInstance) {
        TRACERS.put(classLoader, tracerInstance);
    }

    public void registerTracerBean(@Observes AfterBeanDiscovery abd) {
        abd.addBean().addTransitiveTypeClosure(Tracer.class).produceWith(i -> TRACERS.get(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged()));
    }

    public void skipTracerBeans(@Observes ProcessAnnotatedType<? extends Tracer> processAnnotatedType) {
        TracingLogger.ROOT_LOGGER.extraTracerBean(processAnnotatedType.getAnnotatedType().getJavaClass().getName());
        processAnnotatedType.veto();
    }

    public void beforeShutdown(@Observes BeforeShutdown bs) {
        TRACERS.remove(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged());
    }
}

