/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionConsumerCloseMessage
extends PacketImpl {
    private long consumerID;

    public SessionConsumerCloseMessage(long objectID) {
        super((byte)74);
        this.consumerID = objectID;
    }

    public SessionConsumerCloseMessage() {
        super((byte)74);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.consumerID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.consumerID = buffer.readLong();
    }

    @Override
    protected String getPacketString() {
        return super.getPacketString() + ", consumerID=" + this.consumerID;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.consumerID ^ this.consumerID >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionConsumerCloseMessage)) {
            return false;
        }
        SessionConsumerCloseMessage other = (SessionConsumerCloseMessage)obj;
        return this.consumerID == other.consumerID;
    }
}

