/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aesh.complete.AeshCompleteOperation;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.impl.CLICommandCompleter;
import org.jboss.as.cli.impl.CommandCandidatesProvider;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.parsing.command.CommandFormat;
import org.jboss.as.cli.parsing.operation.OperationFormat;
import org.wildfly.common.Assert;

public class CommandCompleter
implements CommandLineCompleter,
CLICommandCompleter.Completer {
    private final CommandRegistry cmdRegistry;
    private final CommandCandidatesProvider cmdProvider;
    private final CLICommandCompleter cliCompleter = new CLICommandCompleter();

    public CommandCompleter(CommandRegistry cmdRegistry) {
        this.cmdRegistry = Assert.checkNotNullParam("cmdRegistry", cmdRegistry);
        this.cmdProvider = new CommandCandidatesProvider(cmdRegistry);
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        AeshCompleteOperation op = new AeshCompleteOperation(buffer, cursor);
        this.cliCompleter.complete(ctx, op, this);
        if (!op.getCompletionCandidates().isEmpty()) {
            for (TerminalString ts : op.getCompletionCandidates()) {
                candidates.add(ts.getCharacters());
            }
            return op.getOffset();
        }
        return -1;
    }

    @Override
    public void addAllCommandNames(CommandContext ctx, AeshCompleteOperation op) {
        ArrayList<String> candidates = new ArrayList<String>();
        for (String cmd : this.cmdRegistry.getTabCompletionCommands()) {
            CommandHandler handler = this.cmdRegistry.getCommandHandler(cmd);
            if (!handler.isAvailable(ctx)) continue;
            candidates.add(cmd);
        }
        Collections.sort(candidates);
        candidates.add(OperationFormat.INSTANCE.getAddressOperationSeparator());
        op.addCompletionCandidates(candidates);
    }

    @Override
    public void complete(CommandContext ctx, DefaultCallbackHandler parsedCmd, AeshCompleteOperation op) {
        int notIndex;
        parsedCmd = parsedCmd == null ? (DefaultCallbackHandler)ctx.getParsedCommandLine() : parsedCmd;
        String buffer = op.getBuffer();
        int cursor = op.getCursor();
        ArrayList<String> candidates = new ArrayList<String>();
        OperationCandidatesProvider candidatesProvider = buffer.isEmpty() || parsedCmd.getFormat() == CommandFormat.INSTANCE ? this.cmdProvider : ctx.getOperationCandidatesProvider();
        int result = OperationRequestCompleter.INSTANCE.complete(ctx, candidatesProvider, buffer, cursor, candidates);
        if (parsedCmd.getFormat() != OperationFormat.INSTANCE && (notIndex = candidates.indexOf("!")) >= 0) {
            candidates.remove(notIndex);
        }
        if (!candidates.isEmpty()) {
            Collections.sort(candidates);
            op.addCompletionCandidates(candidates);
            op.setOffset(result);
        }
    }
}

