/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.Collections;
import java.util.List;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.Option;

public final class EnumValueDescriptor {
    private final String name;
    private String fullName;
    private String scopedName;
    private final int number;
    private final String documentation;
    private final List<Option> options;
    private EnumDescriptor enumDescriptor;
    private FileDescriptor fileDescriptor;

    private EnumValueDescriptor(Builder builder) {
        this.name = builder.name;
        this.number = builder.number;
        this.documentation = builder.documentation;
        this.options = Collections.unmodifiableList(builder.options);
    }

    public String getName() {
        return this.name;
    }

    public int getNumber() {
        return this.number;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public Option getOption(String name) {
        for (Option o : this.options) {
            if (!o.getName().equals(name)) continue;
            return o;
        }
        return null;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getScopedName() {
        return this.scopedName;
    }

    public EnumDescriptor getContainingEnum() {
        return this.enumDescriptor;
    }

    void setContainingEnum(EnumDescriptor enumDescriptor) {
        this.enumDescriptor = enumDescriptor;
        this.fullName = enumDescriptor.getFullName() + '.' + this.name;
        this.scopedName = enumDescriptor.getFullName().substring(0, enumDescriptor.getFullName().length() - enumDescriptor.getName().length()) + this.name;
    }

    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
    }

    public String toString() {
        return "EnumValueDescriptor{fullName=" + this.fullName + '}';
    }

    public static final class Builder {
        private String name;
        private int number;
        private String documentation;
        private List<Option> options;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withTag(int tag) {
            this.number = tag;
            return this;
        }

        public Builder withDocumentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        public EnumValueDescriptor build() {
            return new EnumValueDescriptor(this);
        }
    }
}

