/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.infinispan.protostream.annotations.ProtoReserved;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.types.XClass;

final class ReservedProcessor {
    private SortedSet<ReservedInterval> reservedNumbers;
    private Map<String, XClass> reservedNames;

    ReservedProcessor() {
    }

    XClass checkReserved(int number) {
        for (ReservedInterval i : this.reservedNumbers) {
            if (!i.contains(number)) continue;
            return i.where;
        }
        return null;
    }

    XClass checkReserved(String name) {
        return this.reservedNames.get(name);
    }

    void scan(XClass javaClass) {
        this.reservedNumbers = new TreeSet<ReservedInterval>();
        this.reservedNames = new TreeMap<String, XClass>();
        this.scanReserved(javaClass, new HashSet<XClass>());
    }

    void generate(IndentWriter iw) {
        boolean first;
        if (!this.reservedNumbers.isEmpty()) {
            iw.append("//");
            iw.append("reserved ");
            first = true;
            ReservedInterval r = null;
            for (ReservedInterval i : this.reservedNumbers) {
                if (r == null) {
                    r = i;
                    continue;
                }
                ReservedInterval j = r.join(i);
                if (j == null) {
                    if (first) {
                        first = false;
                    } else {
                        iw.append(", ");
                    }
                    iw.append(r.toString());
                    r = i;
                    continue;
                }
                r = j;
            }
            if (r != null) {
                if (!first) {
                    iw.append(", ");
                }
                iw.append(r.toString());
            }
            iw.append(";\n");
        }
        if (!this.reservedNames.isEmpty()) {
            iw.append("//");
            iw.append("reserved ");
            first = true;
            for (String name : this.reservedNames.keySet()) {
                if (first) {
                    first = false;
                } else {
                    iw.append(", ");
                }
                iw.append('\"').append(name).append('\"');
            }
            iw.append(";\n");
        }
    }

    private void scanReserved(XClass clazz, Set<XClass> processedClasses) {
        if (!processedClasses.add(clazz)) {
            return;
        }
        if (clazz.getSuperclass() != null) {
            this.scanReserved(clazz.getSuperclass(), processedClasses);
        }
        for (XClass i : clazz.getInterfaces()) {
            this.scanReserved(i, processedClasses);
        }
        for (ProtoReserved reserved : (ProtoReserved[])clazz.getAnnotationsByType(ProtoReserved.class)) {
            ReservedInterval dup;
            ReservedInterval i;
            int[] numbers = reserved.numbers();
            if (numbers.length == 0) {
                numbers = reserved.value();
            } else if (reserved.value().length > 0) {
                throw new ProtoSchemaBuilderException("@ProtoReserved annotation must not specify both 'value' and 'numbers' : " + clazz.getCanonicalName());
            }
            for (int number : numbers) {
                i = new ReservedInterval(clazz, number);
                dup = i.findOverlap(this.reservedNumbers);
                if (dup != null) {
                    if (dup.where.equals(clazz)) {
                        throw new ProtoSchemaBuilderException("Found duplicate @ProtoReserved number " + number + " in " + clazz.getCanonicalName());
                    }
                    throw new ProtoSchemaBuilderException("@ProtoReserved number " + number + " in " + clazz.getCanonicalName() + " conflicts with @ProtoReserved in " + dup.where.getCanonicalName());
                }
                this.reservedNumbers.add(i);
            }
            for (ProtoReserved.Range range : reserved.ranges()) {
                i = new ReservedInterval(clazz, range.from(), range.to());
                dup = i.findOverlap(this.reservedNumbers);
                if (dup != null) {
                    if (dup.where.equals(clazz)) {
                        throw new ProtoSchemaBuilderException("Found overlapping @ProtoReserved range \"" + i + "\" in " + clazz.getCanonicalName());
                    }
                    throw new ProtoSchemaBuilderException("@ProtoReserved range \"" + i + "\" in " + clazz.getCanonicalName() + " conflicts with @ProtoReserved in " + dup.where.getCanonicalName());
                }
                this.reservedNumbers.add(i);
            }
            for (String name : reserved.names()) {
                if (name.isEmpty()) {
                    throw new ProtoSchemaBuilderException("@ProtoReserved name cannot be empty: " + clazz.getCanonicalName());
                }
                XClass dup2 = this.reservedNames.put(name, clazz);
                if (dup2 == null) continue;
                if (dup2.equals(clazz)) {
                    throw new ProtoSchemaBuilderException("Found duplicate @ProtoReserved name \"" + name + "\" in " + clazz.getCanonicalName());
                }
                throw new ProtoSchemaBuilderException("@ProtoReserved name \"" + name + "\" in " + clazz.getCanonicalName() + " conflicts with @ProtoReserved name in " + dup2.getCanonicalName());
            }
        }
    }

    private static final class ReservedInterval
    implements Comparable<ReservedInterval> {
        final XClass where;
        private final int from;
        private final int to;

        ReservedInterval(XClass where, int number) {
            this.where = where;
            this.from = this.to = number;
            if (!where.isEnum()) {
                if (number < 1) {
                    throw new ProtoSchemaBuilderException("Found invalid @ProtoReserved number " + number + " in " + where.getCanonicalName() + ". Must be greater than 0.");
                }
                if (number > 0x1FFFFFFF) {
                    throw new ProtoSchemaBuilderException("Found invalid @ProtoReserved number " + number + " in " + where.getCanonicalName() + ". Must be lower than " + 0x1FFFFFFF + ".");
                }
            }
        }

        ReservedInterval(XClass where, int from, int to) {
            this.where = where;
            this.from = from;
            this.to = to;
            if (from >= to) {
                throw new ProtoSchemaBuilderException("Found invalid @ProtoReserved range \"" + this.rangeAsString() + "\" in " + where.getCanonicalName() + ". 'to' must be greater than 'from'.");
            }
            if (!where.isEnum()) {
                if (from < 1) {
                    throw new ProtoSchemaBuilderException("Found invalid @ProtoReserved range \"" + this + "\" in " + where.getCanonicalName() + ". 'from' must be greater than 0.");
                }
                if (to != Integer.MAX_VALUE && to > 0x1FFFFFFF) {
                    throw new ProtoSchemaBuilderException("Found invalid @ProtoReserved range \"" + this + "\" in " + where.getCanonicalName() + ". 'to' must be lower than " + 0x1FFFFFFF + ".");
                }
            }
        }

        ReservedInterval findOverlap(Set<ReservedInterval> numbers) {
            for (ReservedInterval i : numbers) {
                if (!i.contains(this.from) && !i.contains(this.to)) continue;
                return i;
            }
            return null;
        }

        private boolean contains(int n) {
            return n >= this.from && n <= this.to;
        }

        @Override
        public int compareTo(ReservedInterval i) {
            return this.from - i.from;
        }

        public String toString() {
            return this.from == this.to ? String.valueOf(this.from) : this.rangeAsString();
        }

        private String rangeAsString() {
            boolean toMax = this.to == Integer.MAX_VALUE || !this.where.isEnum() && this.to == 0x1FFFFFFF;
            return this.from + " to " + (toMax ? "max" : String.valueOf(this.to));
        }

        ReservedInterval join(ReservedInterval i) {
            if (this.to == i.from - 1) {
                return new ReservedInterval(this.where, this.from, i.to);
            }
            return null;
        }
    }
}

