/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.balancing.RedirectHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPRedirectContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ConnectionError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;

public class AMQPRedirectHandler
extends RedirectHandler<AMQPRedirectContext> {
    public AMQPRedirectHandler(ActiveMQServer server) {
        super(server);
    }

    public boolean redirect(AMQPConnectionContext connectionContext, Connection protonConnection) throws Exception {
        return this.redirect(new AMQPRedirectContext(connectionContext, protonConnection));
    }

    protected void cannotRedirect(AMQPRedirectContext context) throws Exception {
        ErrorCondition error = new ErrorCondition();
        error.setCondition(ConnectionError.CONNECTION_FORCED);
        error.setDescription(String.format("Broker balancer %s is not ready to redirect", context.getConnection().getTransportConnection().getRedirectTo()));
        Connection protonConnection = context.getProtonConnection();
        protonConnection.setCondition(error);
        this.addConnectionOpenFailureHint(protonConnection);
    }

    protected void redirectTo(AMQPRedirectContext context) throws Exception {
        String host = ConfigurationHelper.getStringProperty((String)"host", (String)"localhost", (Map)context.getTarget().getConnector().getParams());
        int port = ConfigurationHelper.getIntProperty((String)"port", (int)61616, (Map)context.getTarget().getConnector().getParams());
        ErrorCondition error = new ErrorCondition();
        error.setCondition(ConnectionError.REDIRECT);
        error.setDescription(String.format("Connection redirected to %s:%d by broker balancer %s", host, port, context.getConnection().getTransportConnection().getRedirectTo()));
        HashMap<Symbol, Object> info = new HashMap<Symbol, Object>();
        info.put(AmqpSupport.NETWORK_HOST, host);
        info.put(AmqpSupport.PORT, port);
        error.setInfo(info);
        Connection protonConnection = context.getProtonConnection();
        protonConnection.setCondition(error);
        this.addConnectionOpenFailureHint(protonConnection);
    }

    private void addConnectionOpenFailureHint(Connection connection) {
        HashMap<Symbol, Boolean> connProps = new HashMap<Symbol, Boolean>();
        connProps.put(AmqpSupport.CONNECTION_OPEN_FAILED, true);
        connection.setProperties(connProps);
    }
}

