/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.realm;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.cxf.sts.SignatureProperties;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;

public class RealmProperties {
    private static final Logger LOG = LogUtils.getL7dLogger(RealmProperties.class);
    private String name;
    private String issuer;
    private String signatureAlias;
    private Crypto signatureCrypto;
    private SignatureProperties signatureProperties;
    private Object signatureCryptoProperties;
    private String callbackHandlerClass;
    private CallbackHandler callbackHandler;

    public String getIssuer() {
        return this.issuer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getSignatureAlias() {
        return this.signatureAlias;
    }

    public void setSignatureAlias(String signatureAlias) {
        this.signatureAlias = signatureAlias;
    }

    public void setSignatureCrypto(Crypto signatureCrypto) {
        this.signatureCrypto = signatureCrypto;
    }

    public void setSignatureCryptoProperties(Object signatureCryptoProperties) {
        this.signatureCryptoProperties = signatureCryptoProperties;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Setting signature crypto properties: " + signatureCryptoProperties);
        }
    }

    public void setSignatureProperties(SignatureProperties signatureProperties) {
        this.signatureProperties = signatureProperties;
    }

    public SignatureProperties getSignatureProperties() {
        return this.signatureProperties;
    }

    public Crypto getSignatureCrypto() {
        if (this.signatureCrypto == null && this.signatureCryptoProperties != null) {
            Properties sigProperties = SecurityUtils.loadProperties((Object)this.signatureCryptoProperties);
            if (sigProperties == null) {
                LOG.fine("Cannot load signature properties using: " + this.signatureCryptoProperties);
                throw new STSException("Configuration error: cannot load signature properties");
            }
            try {
                this.signatureCrypto = CryptoFactory.getInstance((Properties)sigProperties);
            }
            catch (WSSecurityException ex) {
                LOG.fine("Error in loading the signature Crypto object: " + ex.getMessage());
                throw new STSException(ex.getMessage());
            }
        }
        return this.signatureCrypto;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Setting callbackHandler: " + callbackHandler);
        }
    }

    public void setCallbackHandlerClass(String callbackHandlerClass) {
        this.callbackHandlerClass = callbackHandlerClass;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Setting callbackHandlerClass: " + callbackHandlerClass);
        }
    }

    public CallbackHandler getCallbackHandler() {
        if (this.callbackHandler == null && this.callbackHandlerClass != null) {
            try {
                this.callbackHandler = SecurityUtils.getCallbackHandler((Object)this.callbackHandlerClass);
                if (this.callbackHandler == null) {
                    LOG.fine("Cannot load CallbackHandler using: " + this.callbackHandlerClass);
                    throw new STSException("Configuration error: cannot load callback handler");
                }
            }
            catch (Exception ex) {
                LOG.fine("Error in loading the callback handler object: " + ex.getMessage());
                throw new STSException(ex.getMessage());
            }
        }
        return this.callbackHandler;
    }
}

