/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLStreamException;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.metadata.BundledPatch;
import org.jboss.as.patching.metadata.Identity;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchBundleXml;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.metadata.PatchXml;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

@CommandDefinition(name="inspect", description="")
public class PatchInspect
implements Command<CLICommandInvocation> {
    @Argument(required=true)
    private File patchFile;
    @Option(hasValue=false, shortName=118, required=false)
    boolean verbose;

    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        this.doInspect(commandInvocation.getCommandContext());
        return CommandResult.SUCCESS;
    }

    private void doInspect(CommandContext ctx) throws CommandException {
        if (this.patchFile == null) {
            throw new CommandException("No patch path provided");
        }
        if (!this.patchFile.exists()) {
            throw new CommandException("Failed to locate " + this.patchFile.getAbsolutePath());
        }
        ZipFile patchZip = null;
        InputStream is = null;
        try {
            patchZip = new ZipFile(this.patchFile);
            ZipEntry patchXmlEntry = patchZip.getEntry("patches.xml");
            if (patchXmlEntry == null) {
                patchXmlEntry = patchZip.getEntry("patch.xml");
                if (patchXmlEntry == null) {
                    throw new CommandException("Neither patches.xml nor patch.xml were found in " + this.patchFile.getAbsolutePath());
                }
                is = patchZip.getInputStream(patchXmlEntry);
                Patch patch = PatchXml.parse(is).resolvePatch(null, null);
                this.displayPatchXml(ctx, patch);
            } else {
                is = patchZip.getInputStream(patchXmlEntry);
                List<BundledPatch.BundledPatchEntry> patches = PatchBundleXml.parse(is).getPatches();
                this.displayPatchBundleXml(ctx, patches, patchZip);
            }
        }
        catch (ZipException e) {
            throw new CommandException("Failed to open " + this.patchFile.getAbsolutePath(), (Throwable)e);
        }
        catch (IOException e) {
            throw new CommandException("Failed to open " + this.patchFile.getAbsolutePath(), (Throwable)e);
        }
        catch (PatchingException e) {
            throw new CommandException("Failed to resolve parsed patch", (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new CommandException("Failed to parse patch.xml", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (patchZip != null) {
                try {
                    patchZip.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void displayPatchBundleXml(CommandContext ctx, List<BundledPatch.BundledPatchEntry> patches, ZipFile patchZip) throws CommandException {
        if (patches.isEmpty()) {
            return;
        }
        for (BundledPatch.BundledPatchEntry bundledPatch : patches) {
            ZipEntry bundledZip = patchZip.getEntry(bundledPatch.getPatchPath());
            if (bundledZip == null) {
                throw new CommandException("Patch file not found in the bundle: " + bundledPatch.getPatchPath());
            }
            InputStream is = null;
            ZipInputStream bundledPatchIs = null;
            try {
                is = patchZip.getInputStream(bundledZip);
                bundledPatchIs = new ZipInputStream(is);
                ZipEntry bundledPatchXml = bundledPatchIs.getNextEntry();
                while (bundledPatchXml != null && !"patch.xml".equals(bundledPatchXml.getName())) {
                    bundledPatchXml = bundledPatchIs.getNextEntry();
                }
                if (bundledPatchXml == null) {
                    throw new CommandLineException("Failed to locate patch.xml in bundled patch " + bundledPatch.getPatchPath());
                }
                Patch patch = PatchXml.parse(bundledPatchIs).resolvePatch(null, null);
                if (this.verbose) {
                    ctx.printLine("CONTENT OF " + bundledPatch.getPatchPath() + ':' + Util.LINE_SEPARATOR);
                }
                this.displayPatchXml(ctx, patch);
                ctx.printLine("");
            }
            catch (Exception e) {
                try {
                    throw new CommandException("Failed to inspect " + bundledPatch.getPatchPath(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IoUtils.safeClose(bundledPatchIs);
                    IoUtils.safeClose(is);
                    throw throwable;
                }
            }
            IoUtils.safeClose(bundledPatchIs);
            IoUtils.safeClose(is);
        }
    }

    private void displayPatchXml(CommandContext ctx, Patch patch) throws CommandException {
        Identity identity = patch.getIdentity();
        SimpleTable table = new SimpleTable(2, ctx.getTerminalWidth());
        table.addLine(new String[]{"Patch ID:", patch.getPatchId()});
        table.addLine(new String[]{"Type:", identity.getPatchType().getName()});
        table.addLine(new String[]{"Identity name:", identity.getName()});
        table.addLine(new String[]{"Identity version:", identity.getVersion()});
        table.addLine(new String[]{"Description:", patch.getDescription() == null ? "n/a" : patch.getDescription()});
        if (patch.getLink() != null) {
            table.addLine(new String[]{"Link:", patch.getLink()});
        }
        ctx.printLine(table.toString(false));
        if (this.verbose) {
            ctx.printLine("");
            ctx.printLine("ELEMENTS");
            for (PatchElement e : patch.getElements()) {
                table = new SimpleTable(2, ctx.getTerminalWidth());
                table.addLine(new String[]{"Patch ID:", e.getId()});
                table.addLine(new String[]{"Name:", e.getProvider().getName()});
                table.addLine(new String[]{"Type:", e.getProvider().isAddOn() ? "add-on" : "layer"});
                table.addLine(new String[]{"Description:", e.getDescription()});
                ctx.printLine("");
                ctx.printLine(table.toString(false));
            }
        }
    }
}

