/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.controller.PathAddress;
import org.jboss.modcluster.ModClusterService;
import org.jboss.modcluster.config.ModClusterConfiguration;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.AsyncServiceConfigurator;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ProxyConfigurationResourceDefinition;
import org.wildfly.extension.mod_cluster.ProxyConfigurationServiceConfigurator;

public class ContainerEventHandlerServiceConfigurator
extends CapabilityServiceNameProvider
implements ServiceConfigurator,
Supplier<ModClusterService>,
Consumer<ModClusterService> {
    private final String proxyName;
    private final LoadBalanceFactorProvider factorProvider;
    private final SupplierDependency<ModClusterConfiguration> configuration;

    ContainerEventHandlerServiceConfigurator(PathAddress address, LoadBalanceFactorProvider factorProvider) {
        super((Capability)ProxyConfigurationResourceDefinition.Capability.SERVICE, address);
        this.configuration = new ServiceSupplierDependency((ServiceNameProvider)new ProxyConfigurationServiceConfigurator(address));
        this.proxyName = address.getLastElement().getValue();
        this.factorProvider = factorProvider;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = new AsyncServiceConfigurator(this.getServiceName()).build(target);
        Consumer modClusterService = this.configuration.register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(modClusterService, Function.identity(), (Supplier)this, (Consumer)this);
        return builder.setInstance((Service)service);
    }

    @Override
    public ModClusterService get() {
        ModClusterLogger.ROOT_LOGGER.debugf("Starting mod_cluster service for proxy '%s'.", this.proxyName);
        return new ModClusterService((ModClusterConfiguration)this.configuration.get(), this.factorProvider);
    }

    @Override
    public void accept(ModClusterService service) {
        ModClusterLogger.ROOT_LOGGER.debugf("Stopping mod_cluster service for proxy '%s'.", this.proxyName);
        service.shutdown();
    }
}

