/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.subscription.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.pdc.classification.Criteria;
import org.silverpeas.core.pdc.subscription.model.PdcSubscription;
import org.silverpeas.core.pdc.subscription.model.PdcSubscriptionRuntimeException;
import org.silverpeas.core.persistence.jdbc.DBUtil;

public class PdcSubscriptionDAO {
    public static final String PDC_SUBSRIPTION_TABLE_NAME = "SB_PDC_Subscription";
    public static final String PDC_SUBSRIPTION_AXIS_TABLE_NAME = "SB_PDC_Subscription_Axis";
    public static final String GET_SUBSCRIPTION_BY_USERID_QUERY = "SELECT id, name, ownerId  FROM SB_PDC_Subscription WHERE ownerId = ? ";
    public static final String GET_ALL_SUBSCRIPTIONS_QUERY = "SELECT id, name, ownerId FROM SB_PDC_Subscription";
    public static final String GET_CRITERIAS_BY_SC_ID_QUERY = "SELECT id, pdcSubscriptionId, axisId, value FROM SB_PDC_Subscription_Axis WHERE pdcSubscriptionId = ? ";
    public static final String GET_SUBSCRIPTION_BY_ID_QUERY = "SELECT id, name, ownerId FROM SB_PDC_Subscription WHERE id = ? ";
    public static final String CREATE_PDCSUBSCR_QUERY = "INSERT INTO SB_PDC_Subscription (id, name, ownerId ) VALUES (?, ?, ?)";
    public static final String CREATE_PDC_SEARCHCRITERIA_QUERY = "INSERT INTO SB_PDC_Subscription_Axis (id, pdcSubscriptionId, axisId, value) VALUES (?, ?, ?, ?)";
    public static final String UPDATE_PDC_SUBSCR_QUERY = "UPDATE SB_PDC_Subscription SET name = ? , ownerId = ? WHERE id = ? ";
    public static final String REMOVE_SUBSCR_BYID_QUERY = "delete from SB_PDC_Subscription where id = ? ";
    public static final String REMOVE_SCS_QUERY = "delete from SB_PDC_Subscription_Axis where pdcSubscriptionId = ? ";
    public static final String FIND_SUBSCRIPTION_BY_AXIS_QUERY = "SELECT pdcSubscriptionId FROM SB_PDC_Subscription_Axis WHERE axisId = ? ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PdcSubscription> getPDCSubscriptionByUserId(Connection conn, int userId) throws PdcSubscriptionRuntimeException, SQLException {
        if (conn == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.getPDCSubscriptionByUserId", 4, "root.EX_NO_CONNECTION");
        }
        if (userId < 0) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.getPDCSubscriptionByUserId", 4, "root.EX_NULL_VALUE_OBJECT_OR_PK");
        }
        ArrayList<PdcSubscription> result = new ArrayList<PdcSubscription>();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = conn.prepareStatement(GET_SUBSCRIPTION_BY_USERID_QUERY);
            prepStmt.setInt(1, userId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                PdcSubscription sc = PdcSubscriptionDAO.getSubScFromRS(rs);
                sc.setPdcContext(PdcSubscriptionDAO.getCriteriasBySubscriptionID(conn, sc.getId()));
                result.add(sc);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PdcSubscription> getAllPDCSubscriptions(Connection conn) throws PdcSubscriptionRuntimeException, SQLException {
        if (conn == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.getAllPDCSubscriptions", 4, "root.EX_NO_CONNECTION");
        }
        ArrayList<PdcSubscription> result = new ArrayList<PdcSubscription>();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = conn.prepareStatement(GET_ALL_SUBSCRIPTIONS_QUERY);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                PdcSubscription sc = PdcSubscriptionDAO.getSubScFromRS(rs);
                sc.setPdcContext(PdcSubscriptionDAO.getCriteriasBySubscriptionID(conn, sc.getId()));
                result.add(sc);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return result;
    }

    private static PdcSubscription getSubScFromRS(ResultSet rs) throws SQLException, PdcSubscriptionRuntimeException {
        PdcSubscription result = new PdcSubscription(rs.getInt("id"), rs.getString("name"), null, rs.getInt("ownerId"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Criteria> getCriteriasBySubscriptionID(Connection conn, int scId) throws PdcSubscriptionRuntimeException, SQLException {
        if (conn == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.getCriteriasBySubscriptionID", 4, "root.EX_NO_CONNECTION");
        }
        ArrayList<Criteria> result = new ArrayList<Criteria>();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        if (scId < 0) {
            return result;
        }
        try {
            prepStmt = conn.prepareStatement(GET_CRITERIAS_BY_SC_ID_QUERY);
            prepStmt.setInt(1, scId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                Criteria sc = PdcSubscriptionDAO.getSCFromRS(rs);
                result.add(sc);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return result;
    }

    private static Criteria getSCFromRS(ResultSet rs) throws SQLException, PdcSubscriptionRuntimeException {
        Criteria result = new Criteria(rs.getInt("axisId"), rs.getString("value"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PdcSubscription getPDCSubsriptionById(Connection conn, int id) throws PdcSubscriptionRuntimeException, SQLException {
        if (conn == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.PDCSubsriptionById", 4, "root.EX_NO_CONNECTION");
        }
        if (id < 0) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.PDCSubsriptionById", 4, "root.EX_WRONG_PK");
        }
        PdcSubscription result = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = conn.prepareStatement(GET_SUBSCRIPTION_BY_ID_QUERY);
            prepStmt.setInt(1, id);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                result = PdcSubscriptionDAO.getSubScFromRS(rs);
                result.setPdcContext(PdcSubscriptionDAO.getCriteriasBySubscriptionID(conn, result.getId()));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createPDCSubscription(Connection conn, PdcSubscription subscription) throws PdcSubscriptionRuntimeException, SQLException {
        if (conn == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.createPDCSubscription", 4, "root.EX_NO_CONNECTION");
        }
        if (subscription == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.createPDCSubscription", 4, "root.EX_NULL_VALUE_OBJECT_OR_PK");
        }
        PreparedStatement prepStmt = null;
        int newId = -1;
        try {
            newId = DBUtil.getNextId((String)PDC_SUBSRIPTION_TABLE_NAME, (String)"id");
        }
        catch (Exception e) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.createPDCSubscription", 4, "root.EX_GET_NEXTID_FAILED", PDC_SUBSRIPTION_TABLE_NAME, e);
        }
        try {
            prepStmt = conn.prepareStatement(CREATE_PDCSUBSCR_QUERY);
            prepStmt.setInt(1, newId);
            prepStmt.setString(2, subscription.getName());
            prepStmt.setInt(3, subscription.getOwnerId());
            int rownum = prepStmt.executeUpdate();
            if (rownum < 1) {
                throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.createPDCSubscription", 4, "root.EX_RECORD_INSERTION_FAILED", subscription);
            }
            List<? extends Criteria> ctx = subscription.getPdcContext();
            if (ctx != null && !ctx.isEmpty()) {
                PdcSubscriptionDAO.createSearchCriterias(conn, ctx, newId);
            }
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSearchCriterias(Connection conn, List<? extends Criteria> searchCriterias, int subscriptionId) throws PdcSubscriptionRuntimeException, SQLException {
        if (conn == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.createSearchCriterias", 4, "root.EX_NO_CONNECTION");
        }
        if (searchCriterias == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.createSearchCriterias", 4, "root.EX_NULL_VALUE_OBJECT_OR_PK");
        }
        if (searchCriterias.isEmpty()) {
            return;
        }
        PreparedStatement prepStmt = null;
        int newId = -1;
        try {
            prepStmt = conn.prepareStatement(CREATE_PDC_SEARCHCRITERIA_QUERY);
            for (Criteria criteria : searchCriterias) {
                try {
                    newId = DBUtil.getNextId((String)PDC_SUBSRIPTION_AXIS_TABLE_NAME, (String)"id");
                }
                catch (Exception e) {
                    throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.createSearchCriterias", 4, "root.EX_GET_NEXTID_FAILED", PDC_SUBSRIPTION_AXIS_TABLE_NAME, e);
                }
                prepStmt.setInt(1, newId);
                prepStmt.setInt(2, subscriptionId);
                prepStmt.setInt(3, criteria.getAxisId());
                prepStmt.setString(4, criteria.getValue());
                int rownum = prepStmt.executeUpdate();
                if (rownum >= 1) continue;
                throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.createSearchCriterias", 4, "root.EX_RECORD_INSERTION_FAILED", criteria);
            }
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePDCSubscription(Connection conn, PdcSubscription subscription) throws PdcSubscriptionRuntimeException, SQLException {
        if (conn == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.updatePDCSubscription", 4, "root.EX_NO_CONNECTION");
        }
        if (subscription == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.updatePDCSubscription", 4, "root.EX_NULL_VALUE_OBJECT_OR_PK");
        }
        PreparedStatement prepStmt = null;
        try {
            prepStmt = conn.prepareStatement(UPDATE_PDC_SUBSCR_QUERY);
            prepStmt.setString(1, subscription.getName());
            prepStmt.setInt(2, subscription.getOwnerId());
            prepStmt.setInt(3, subscription.getId());
            int rownum = prepStmt.executeUpdate();
            if (rownum < 1) {
                throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.updatePDCSubscription", 4, "root.EX_RECORD_UPDATE_FAILED", subscription);
            }
            List<? extends Criteria> ctx = subscription.getPdcContext();
            PdcSubscriptionDAO.removeSearchCriterias(conn, subscription.getId());
            if (ctx != null && !ctx.isEmpty()) {
                PdcSubscriptionDAO.createSearchCriterias(conn, ctx, subscription.getId());
            }
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePDCSubscriptionById(Connection conn, int id) throws PdcSubscriptionRuntimeException, SQLException {
        if (conn == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.removePDCSubscriptionById", 4, "root.EX_NO_CONNECTION");
        }
        if (id < 0) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.removePDCSubscriptionById", 4, "root.EX_WRONG_PK");
        }
        PreparedStatement prepStmt = null;
        try {
            prepStmt = conn.prepareStatement(REMOVE_SUBSCR_BYID_QUERY);
            prepStmt.setInt(1, id);
            int rownum = prepStmt.executeUpdate();
            PdcSubscriptionDAO.removeSearchCriterias(conn, id);
            if (rownum < 1) {
                throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.removePDCSubscriptionById", 4, "root.EX_RECORD_NOTFOUND", String.valueOf(id));
            }
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    private static void removeSearchCriterias(Connection conn, int subscrID) throws PdcSubscriptionRuntimeException, SQLException {
        if (conn == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.removeSearchCriterias", 4, "root.EX_NO_CONNECTION");
        }
        if (subscrID < 0) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.removeSearchCriterias", 4, "root.EX_WRONG_PK");
        }
        PreparedStatement prepStmt = null;
        try {
            prepStmt = conn.prepareStatement(REMOVE_SCS_QUERY);
            prepStmt.setInt(1, subscrID);
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static void removePDCSubscriptionById(Connection conn, int[] ids) throws PdcSubscriptionRuntimeException, SQLException {
        if (conn == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.removePDCSubscriptionById", 4, "root.EX_NO_CONNECTION");
        }
        if (ids == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.removePDCSubscriptionById", 4, "root.EX_NULL_VALUE_OBJECT_OR_PK");
        }
        for (int id : ids) {
            PdcSubscriptionDAO.removePDCSubscriptionById(conn, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PdcSubscription> getPDCSubscriptionByUsedAxis(Connection conn, int axisId) throws PdcSubscriptionRuntimeException, SQLException {
        if (conn == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.getPDCSubscriptionByUsedAxis", 4, "root.EX_NO_CONNECTION");
        }
        if (axisId < 0) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionDAO.getPDCSubscriptionByUsedAxis", 4, "root.EX_NULL_VALUE_OBJECT_OR_PK");
        }
        ArrayList<PdcSubscription> result = new ArrayList<PdcSubscription>();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = conn.prepareStatement(FIND_SUBSCRIPTION_BY_AXIS_QUERY);
            prepStmt.setInt(1, axisId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                Integer subscrId = rs.getInt(1);
                if (ids.contains(subscrId)) continue;
                ids.add(subscrId);
            }
            for (Integer subscrId : ids) {
                PdcSubscription subscription = PdcSubscriptionDAO.getPDCSubsriptionById(conn, subscrId);
                result.add(subscription);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return result;
    }
}

