/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.viewer.service;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.converter.DocumentFormat;
import org.silverpeas.core.contribution.converter.ToPDFConverter;
import org.silverpeas.core.contribution.converter.option.FilterOption;
import org.silverpeas.core.io.temp.TemporaryWorkspaceTranslation;
import org.silverpeas.core.thread.ManagedThreadPool;
import org.silverpeas.core.util.DocumentInfo;
import org.silverpeas.core.util.PdfUtil;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.viewer.flexpaper.TemporaryFlexPaperView;
import org.silverpeas.core.viewer.model.DocumentView;
import org.silverpeas.core.viewer.model.TemporaryPdfView;
import org.silverpeas.core.viewer.model.ViewerSettings;
import org.silverpeas.core.viewer.service.AbstractViewerService;
import org.silverpeas.core.viewer.service.JsonPdfToolManager;
import org.silverpeas.core.viewer.service.PreviewService;
import org.silverpeas.core.viewer.service.ViewService;
import org.silverpeas.core.viewer.service.ViewerContext;
import org.silverpeas.core.viewer.service.ViewerException;
import org.silverpeas.core.viewer.util.JsonPdfUtil;
import org.silverpeas.core.viewer.util.SwfUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
public class DefaultViewService
extends AbstractViewerService
implements ViewService {
    private static final String PROCESS_NAME = "VIEW";
    @Inject
    private ToPDFConverter toPDFConverter;
    @Inject
    private JsonPdfToolManager jsonPdfToolManager;

    private static boolean isSwfNeeded() {
        return StringUtil.isDefined((String)ViewerSettings.getLicenceKey()) || !ViewerSettings.pdfViewerEnabled();
    }

    @Override
    public boolean isViewable(File file) {
        String filePath = file.getPath();
        boolean toolsAvailable = !DefaultViewService.isSwfNeeded() || SwfUtil.isPdfToSwfActivated();
        return toolsAvailable && file.exists() && (FileUtil.isPdf((String)filePath) || this.toPDFConverter.isDocumentSupported(filePath));
    }

    @Override
    public DocumentView getDocumentView(final ViewerContext viewerContext) {
        return this.process(PROCESS_NAME, new AbstractViewerService.ViewerTreatment<DocumentView>(){

            @Override
            public DocumentView execute() {
                DocumentView documentView;
                File pdfFile;
                if (!DefaultViewService.this.isViewable(viewerContext.getOriginalSourceFile())) {
                    throw new ViewerException("IT IS NOT POSSIBLE GETTING DOCUMENT VIEW");
                }
                if (DefaultViewService.this.toPDFConverter.isDocumentSupported(viewerContext.getOriginalSourceFile().getPath())) {
                    pdfFile = DefaultViewService.this.toPdf(viewerContext.getOriginalSourceFile(), DefaultViewService.this.generateTmpFile(viewerContext, "pdf"));
                } else {
                    pdfFile = DefaultViewService.this.generateTmpFile(viewerContext, "pdf");
                    try {
                        FileUtils.copyFile((File)viewerContext.getOriginalSourceFile(), (File)pdfFile);
                    }
                    catch (IOException e) {
                        SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
                    }
                }
                if (DefaultViewService.isSwfNeeded()) {
                    documentView = DefaultViewService.this.toSwfResult(viewerContext, pdfFile);
                    FileUtils.deleteQuietly((File)pdfFile);
                } else {
                    documentView = DefaultViewService.this.toPdfResult(viewerContext, pdfFile);
                }
                return documentView;
            }

            @Override
            public DocumentView performAfterSuccess(DocumentView result) {
                if (ViewerSettings.isSilentConversionEnabled() && viewerContext.isProcessingCache() && PreviewService.get().isPreviewable(viewerContext.getOriginalSourceFile())) {
                    ManagedThreadPool.getPool().invoke(new Runnable[]{() -> PreviewService.get().getPreview(viewerContext.copy())});
                }
                return AbstractViewerService.ViewerTreatment.super.performAfterSuccess(result);
            }
        }).execute(viewerContext);
    }

    @Override
    public void removeDocumentView(ViewerContext viewerContext) {
        Optional.of(viewerContext.fromInitializerProcessName(PROCESS_NAME).getWorkspace()).filter(TemporaryWorkspaceTranslation::exists).ifPresent(TemporaryWorkspaceTranslation::remove);
    }

    private File toPdf(File source, File destination) {
        this.toPDFConverter.convert(source, destination, DocumentFormat.pdf, new FilterOption[0]);
        return destination;
    }

    private DocumentView toSwfResult(ViewerContext viewerContext, File pdfSource) {
        DocumentInfo info = PdfUtil.getDocumentInfo((File)pdfSource);
        File swfFile = this.changeFileExtension(pdfSource, "swf");
        boolean created = swfFile.getParentFile().mkdirs();
        if (!created) {
            SilverLogger.getLogger((Object)this).warn("Unable to create directory " + String.valueOf(swfFile.getParentFile()), new Object[0]);
        }
        boolean jsonConversion = this.jsonPdfToolManager.isActivated();
        boolean splitMode = ViewerSettings.isSplitStrategyEnabled();
        if (!splitMode) {
            try {
                SwfUtil.fromPdfToSwf(pdfSource, swfFile, false);
                jsonConversion = false;
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
                splitMode = true;
            }
        }
        if (splitMode) {
            swfFile = new File(swfFile.getParentFile(), "page.swf");
            SwfUtil.fromPdfToSwf(pdfSource, swfFile, true);
            if (jsonConversion) {
                try {
                    JsonPdfUtil.convert(pdfSource, swfFile);
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
                    jsonConversion = false;
                }
            }
        }
        TemporaryFlexPaperView documentView = new TemporaryFlexPaperView(viewerContext, swfFile, info);
        documentView.markDocumentSplit(splitMode);
        documentView.markSearchDataComputed(jsonConversion);
        return documentView;
    }

    private DocumentView toPdfResult(ViewerContext viewerContext, File pdfSource) {
        DocumentInfo info = PdfUtil.getDocumentInfo((File)pdfSource);
        File pdfFile = new File(pdfSource.getPath());
        return new TemporaryPdfView(viewerContext, pdfFile, info);
    }
}

