/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contact.model;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.contact.model.Contact;
import org.silverpeas.core.contact.model.ContactDetail;
import org.silverpeas.core.contact.model.ContactPK;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldDisplayer;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.form.TypeManager;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateImpl;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class CompleteContact
implements Contact,
Serializable {
    private static final long serialVersionUID = 6098500884583430615L;
    private ContactDetail contactDetail;
    private String modelId;
    private List<FileItem> formItems;
    private List<String> formValues;
    private Map<String, String> formNamedValues;
    private String creatorLanguage;

    public CompleteContact(ContactDetail contactDetail, String modelId) {
        this.contactDetail = contactDetail;
        this.modelId = modelId;
    }

    public CompleteContact(String instanceId, String modelId) {
        this(new ContactDetail(new ContactPK(null, instanceId)), modelId);
    }

    public ContactDetail getContactDetail() {
        return this.contactDetail;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Override
    public ContactPK getPK() {
        return this.contactDetail.getPK();
    }

    @Override
    public String getFirstName() {
        return this.contactDetail.getFirstName();
    }

    @Override
    public String getLastName() {
        return this.contactDetail.getLastName();
    }

    @Override
    public String getEmail() {
        return this.contactDetail.getEmail();
    }

    @Override
    public String getPhone() {
        return this.contactDetail.getPhone();
    }

    @Override
    public String getFax() {
        return this.contactDetail.getFax();
    }

    @Override
    public Date getCreationDate() {
        return this.contactDetail.getCreationDate();
    }

    public void setCreationDate(Date date) {
        this.contactDetail.setCreationDate(date);
    }

    @Override
    public String getCreatorId() {
        return this.contactDetail.getCreatorId();
    }

    public void setCreatorId(String id) {
        this.contactDetail.setCreatorId(id);
    }

    @Override
    public String getUserId() {
        return this.contactDetail.getUserId();
    }

    @Override
    public UserFull getUserFull() {
        return this.contactDetail.getUserFull();
    }

    public Form getUpdateForm() {
        return this.getForm(true);
    }

    public Form getViewForm() {
        return this.getForm(false);
    }

    public boolean isFormDefined() {
        return StringUtil.isDefined((String)this.modelId) && this.modelId.endsWith(".xml");
    }

    private String getFullTemplateId() {
        return this.getPK().getInstanceId() + ":" + this.getFormName();
    }

    private String getFormName() {
        return FilenameUtils.getBaseName((String)this.modelId);
    }

    private Form getForm(boolean updateMode) {
        Form form = null;
        try {
            if (this.isFormDefined()) {
                this.registerForm(this.modelId);
                PublicationTemplateManager templateManager = PublicationTemplateManager.getInstance();
                PublicationTemplateImpl pubTemplate = (PublicationTemplateImpl)templateManager.getPublicationTemplate(this.getFullTemplateId());
                form = updateMode ? pubTemplate.getUpdateForm() : pubTemplate.getViewForm();
                RecordSet recordSet = pubTemplate.getRecordSet();
                DataRecord data = recordSet.getRecord(this.getPK().getId());
                if (data == null) {
                    data = recordSet.getEmptyRecord();
                    data.setId(this.getPK().getId());
                }
                form.setData(data);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        return form;
    }

    public void saveForm() throws PublicationTemplateException, FormException {
        if (this.isFormDefined()) {
            PublicationTemplateManager templateManager = PublicationTemplateManager.getInstance();
            PublicationTemplateImpl pubTemplate = (PublicationTemplateImpl)templateManager.getPublicationTemplate(this.getFullTemplateId(), this.modelId);
            Form formUpdate = pubTemplate.getUpdateForm();
            RecordSet recordSet = pubTemplate.getRecordSet();
            DataRecord data = recordSet.getRecord(this.getPK().getId());
            if (data == null) {
                data = recordSet.getEmptyRecord();
                data.setId(this.getPK().getId());
            }
            PagesContext context = new PagesContext("useless", "0", this.getCreatorLanguage(), false, this.getPK().getInstanceId(), this.getCreatorId());
            context.setObjectId(this.getPK().getId());
            if (this.getFormItems() != null && !this.getFormItems().isEmpty()) {
                formUpdate.update(this.getFormItems(), data, context);
            } else if (this.getFormValues() != null && !this.getFormValues().isEmpty()) {
                FieldTemplate[] fieldTemplates = pubTemplate.getRecordTemplate().getFieldTemplates();
                int fieldIndex = 0;
                for (String value : this.getFormValues()) {
                    FieldTemplate fieldTemplate;
                    if (StringUtil.isDefined((String)value) && (fieldTemplate = fieldTemplates[fieldIndex]) != null) {
                        String fieldName = fieldTemplate.getFieldName();
                        data.getField(fieldName).setObjectValue((Object)value);
                    }
                    ++fieldIndex;
                }
            } else if (this.getFormNamedValues() != null) {
                FieldTemplate[] fieldTemplates;
                for (FieldTemplate fieldTemplate : fieldTemplates = pubTemplate.getRecordTemplate().getFieldTemplates()) {
                    String fieldName = fieldTemplate.getFieldName();
                    data.getField(fieldName).setObjectValue((Object)this.getFormNamedValues().get(fieldName));
                }
            }
            recordSet.save(data);
        }
    }

    public void removeForm() throws PublicationTemplateException, FormException {
        if (this.isFormDefined()) {
            PublicationTemplate pubTemplate = PublicationTemplateManager.getInstance().getPublicationTemplate(this.getFullTemplateId());
            RecordSet recordSet = pubTemplate.getRecordSet();
            DataRecord data = recordSet.getRecord(this.getPK().getId());
            recordSet.delete(data.getId());
        }
    }

    public void indexForm(FullIndexEntry indexEntry) {
        if (this.isFormDefined()) {
            try {
                PublicationTemplate pub = PublicationTemplateManager.getInstance().getPublicationTemplate(this.getFullTemplateId());
                RecordSet set = pub.getRecordSet();
                set.indexRecord(this.contactDetail.getPK().getId(), this.getFormName(), indexEntry);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }

    public void setFormItems(List<FileItem> formItems) {
        this.formItems = formItems;
    }

    public List<FileItem> getFormItems() {
        return this.formItems;
    }

    public void setFormValues(List<String> formValues) {
        this.formValues = formValues;
    }

    public List<String> getFormValues() {
        return this.formValues;
    }

    public Map<String, String> getFormValues(String language, boolean onlyDefinedValues) {
        HashMap<String, String> formValues = new HashMap<String, String>();
        if (this.isFormDefined()) {
            DataRecord data = null;
            PublicationTemplate pub = null;
            try {
                pub = PublicationTemplateManager.getInstance().getPublicationTemplate(this.getFullTemplateId());
                data = pub.getRecordSet().getRecord(this.getPK().getId());
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).warn("Cannot get form " + this.getPK().getId() + " with info " + this.getModelId(), new Object[0]);
            }
            if (data != null) {
                String[] fieldNames = data.getFieldNames();
                PagesContext pageContext = new PagesContext();
                pageContext.setLanguage(language);
                for (String fieldName : fieldNames) {
                    try {
                        Field field = data.getField(fieldName);
                        GenericFieldTemplate fieldTemplate = (GenericFieldTemplate)pub.getRecordTemplate().getFieldTemplate(fieldName);
                        FieldDisplayer fieldDisplayer = TypeManager.getInstance().getDisplayer(fieldTemplate.getTypeName(), "simpletext");
                        StringWriter sw = new StringWriter();
                        PrintWriter out = new PrintWriter(sw);
                        fieldDisplayer.display(out, field, (FieldTemplate)fieldTemplate, pageContext);
                        String value = sw.toString();
                        if (onlyDefinedValues && (!onlyDefinedValues || !StringUtil.isDefined((String)value))) continue;
                        formValues.put(fieldName, sw.toString());
                    }
                    catch (Exception e) {
                        SilverLogger.getLogger((Object)this).error((Throwable)e);
                    }
                }
            }
        }
        return formValues;
    }

    public void setFormNamedValues(Map<String, String> formNamedValues) {
        this.formNamedValues = formNamedValues;
    }

    public Map<String, String> getFormNamedValues() {
        return this.formNamedValues;
    }

    public void setCreatorLanguage(String creatorLanguage) {
        this.creatorLanguage = creatorLanguage;
    }

    public String getCreatorLanguage() {
        return this.creatorLanguage;
    }

    private void registerForm(String xmlFormName) throws PublicationTemplateException {
        String key = this.getFullTemplateId();
        PublicationTemplateManager templateManager = PublicationTemplateManager.getInstance();
        templateManager.addDynamicPublicationTemplate(key, xmlFormName);
    }
}

