/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.container.ContainerLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletContext;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletSessionImpl
implements PortletSession {
    private static final String PORTLET_SCOPE_ATTR_PREFIX = "javax.portlet.p.";
    private static int LENGTH_OF_PORTLET_SCOPE_ATTR_PREFIX = "javax.portlet.p.".length();
    private static final String QUESTION = "?";
    private HttpSession httpSession;
    private PortletContext portletContext;
    private String windowID;
    private static Logger logger = ContainerLogger.getLogger(PortletSessionImpl.class, (String)"PAELogMessages");

    public PortletSessionImpl(HttpSession session, PortletContext portletContext, String windowID) {
        this.httpSession = session;
        this.portletContext = portletContext;
        this.windowID = windowID;
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        return this.getAttribute(name, 2);
    }

    public Object getAttribute(String name, int scope) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("The given attribute name is null");
        }
        String encodedName = this.getEncodedAttrName(name, scope);
        Object value = this.httpSession.getAttribute(encodedName);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSPL_PAECSPPI0046", new String[]{encodedName, String.valueOf(scope)});
        }
        return value;
    }

    public Enumeration getAttributeNames() {
        return this.getAttributeNames(2);
    }

    public Enumeration getAttributeNames(int scope) {
        Enumeration attrNames = this.httpSession.getAttributeNames();
        ArrayList<String> attrs = new ArrayList<String>();
        if (scope == 1) {
            while (attrNames.hasMoreElements()) {
                String attrName = (String)attrNames.nextElement();
                if (attrName.startsWith(PORTLET_SCOPE_ATTR_PREFIX)) continue;
                attrs.add(attrName);
            }
        } else {
            while (attrNames.hasMoreElements()) {
                String attrName = (String)attrNames.nextElement();
                if (!this.isTargetPortletID(attrName)) continue;
                attrs.add(this.getDecodedAttrName(attrName));
            }
        }
        return Collections.enumeration(attrs);
    }

    public long getCreationTime() {
        return this.httpSession.getCreationTime();
    }

    public String getId() {
        return this.httpSession.getId();
    }

    public long getLastAccessedTime() {
        return this.httpSession.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.httpSession.getMaxInactiveInterval();
    }

    public void invalidate() {
        this.httpSession.invalidate();
    }

    public boolean isNew() {
        return this.httpSession.isNew();
    }

    public void removeAttribute(String name) throws IllegalArgumentException {
        this.removeAttribute(name, 2);
    }

    public void removeAttribute(String name, int scope) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("The given attribute name is null");
        }
        String encodedName = this.getEncodedAttrName(name, scope);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSPL_PAECSPPI0046", new String[]{encodedName, String.valueOf(scope)});
        }
        this.httpSession.removeAttribute(encodedName);
    }

    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        this.setAttribute(name, value, 2);
    }

    public void setAttribute(String name, Object value, int scope) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("The given attribute name is null");
        }
        String encodedName = this.getEncodedAttrName(name, scope);
        this.httpSession.setAttribute(encodedName, value);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSPL_PAECSPPI0046", new String[]{encodedName, String.valueOf(scope)});
        }
    }

    public void setMaxInactiveInterval(int interval) {
        this.httpSession.setMaxInactiveInterval(interval);
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    protected String getHttpSessionId() {
        return this.httpSession.getId();
    }

    public Map<String, Object> getAttributeMap() {
        Enumeration attributeNames = this.getAttributeNames();
        if (attributeNames.hasMoreElements()) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                attributes.put(attributeName, this.getAttribute(attributeName));
            }
            return Collections.unmodifiableMap(attributes);
        }
        return Collections.emptyMap();
    }

    public Map<String, Object> getAttributeMap(int scope) {
        Enumeration attributeNames = this.getAttributeNames(scope);
        if (attributeNames.hasMoreElements()) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                attributes.put(attributeName, this.getAttribute(attributeName, scope));
            }
            return Collections.unmodifiableMap(attributes);
        }
        return Collections.emptyMap();
    }

    public String getWindowID() {
        return this.windowID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PortletSession:{");
        sb.append("WindowID=");
        sb.append(this.getWindowID());
        sb.append(", HttpSessionID=");
        sb.append(this.getId());
        sb.append("}");
        return sb.toString();
    }

    private String getEncodedAttrName(String name, int scope) {
        String encodedName = null;
        if (scope == 1) {
            encodedName = name;
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append(PORTLET_SCOPE_ATTR_PREFIX);
            sb.append(this.getWindowID());
            sb.append(QUESTION);
            sb.append(name);
            encodedName = sb.toString();
        }
        return encodedName;
    }

    private String getDecodedAttrName(String attrName) {
        return attrName.substring(attrName.indexOf(QUESTION) + 1);
    }

    private boolean isTargetPortletID(String name) {
        boolean valid = true;
        if (!name.startsWith(PORTLET_SCOPE_ATTR_PREFIX) || name.indexOf(QUESTION) != name.lastIndexOf(QUESTION)) {
            valid = false;
        } else {
            String portletID = name.substring(LENGTH_OF_PORTLET_SCOPE_ATTR_PREFIX, name.indexOf(QUESTION));
            if (!portletID.equals(this.getWindowID())) {
                valid = false;
            }
        }
        return valid;
    }
}

