/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.appengine.PortletAppEngineUtils;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.PortletRequestDispatcherImpl;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequestDispatcher;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletContextImpl
implements PortletContext {
    public static final String SERVLET_CONTEXT = "javax.portlet.servletContext";
    public static final String SERVER_INFO = "OpenPortal Portlet Container/2.1";
    private static final int MAJOR_VERSION = 2;
    private static final int MINOR_VERSION = 0;
    private ServletContext servletContext;
    private Logger portletLogger;
    private PortletAppDescriptor portletAppDescriptor;
    private static List<String> supportContainerRuntimeOptions = Arrays.asList("javax.portlet.actionScopedRequestAttributes", "javax.portlet.escapeXml");

    public PortletContextImpl(ServletContext servletContext, PortletAppDescriptor portletAppDescriptor) {
        this.servletContext = servletContext;
        this.portletAppDescriptor = portletAppDescriptor;
        this.servletContext.setAttribute(SERVLET_CONTEXT, (Object)this.servletContext);
        String portletAppName = PortletAppEngineUtils.getPortletAppName(servletContext);
        this.portletLogger = ContainerLogger.getLogger((String)("com.sun.portal.portletcontainer." + portletAppName));
    }

    public String getServerInfo() {
        return SERVER_INFO;
    }

    public PortletRequestDispatcher getRequestDispatcher(String path) {
        PortletRequestDispatcherImpl portletRD = null;
        RequestDispatcher servletRD = null;
        try {
            servletRD = this.servletContext.getRequestDispatcher(path);
        }
        catch (Exception e) {
            servletRD = null;
        }
        if (servletRD != null) {
            portletRD = new PortletRequestDispatcherImpl(this.servletContext, servletRD, this.portletAppDescriptor.getServletURLPatterns(), path);
        }
        return portletRD;
    }

    public PortletRequestDispatcher getNamedDispatcher(String name) {
        PortletRequestDispatcherImpl portletRD = null;
        RequestDispatcher servletRD = this.servletContext.getNamedDispatcher(name);
        if (servletRD != null) {
            portletRD = new PortletRequestDispatcherImpl(this.servletContext, servletRD);
        }
        return portletRD;
    }

    public InputStream getResourceAsStream(String path) {
        return this.servletContext.getResourceAsStream(path);
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 0;
    }

    public String getMimeType(String file) {
        return this.servletContext.getMimeType(file);
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public Set getResourcePaths(String path) {
        return this.servletContext.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException();
        }
        return this.servletContext.getResource(path);
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("The given attribute name is null");
        }
        return this.servletContext.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.servletContext.getAttributeNames();
    }

    public String getInitParameter(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("The given parameter name is null");
        }
        return this.servletContext.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.servletContext.getInitParameterNames();
    }

    public String getPortletContextName() {
        return this.servletContext.getServletContextName();
    }

    public void log(String msg) {
        this.servletContext.log(msg);
        this.portletLogger.log(Level.INFO, msg);
    }

    public void log(String message, Throwable throwable) {
        this.servletContext.log(message, throwable);
        this.portletLogger.log(Level.WARNING, message, throwable);
    }

    public void removeAttribute(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("The given attribute name is null");
        }
        this.servletContext.removeAttribute(name);
    }

    public void setAttribute(String name, Object object) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("The given attribute name is null");
        }
        this.servletContext.setAttribute(name, object);
    }

    public Enumeration<String> getContainerRuntimeOptions() {
        return Collections.enumeration(supportContainerRuntimeOptions);
    }
}

