/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletXMLDocumentHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.portlet.PortletURLGenerationListener;
import org.w3c.dom.Element;

public class URLListenerDescriptor {
    private Map<String, String> descriptionMap;
    private Map<String, String> displayNameMap;
    private PortletURLGenerationListener listener;
    private static Logger logger = ContainerLogger.getLogger(PortletDescriptor.class, (String)"PCCLogMessages");

    public void load(Element listenerElement, String namespaceURI) {
        this.descriptionMap = PortletXMLDocumentHelper.getDescriptionMap(listenerElement);
        this.displayNameMap = PortletXMLDocumentHelper.getDisplayNameMap(listenerElement);
        String listenerClassName = PortletXMLDocumentHelper.getChildTextTrim(listenerElement, "listener-class");
        try {
            Class<?> listenerClass = Thread.currentThread().getContextClassLoader().loadClass(listenerClassName);
            logger.log(Level.INFO, "PSPL_PCCCSPPCCD0018", listenerClassName);
            this.listener = (PortletURLGenerationListener)listenerClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            logger.log(this.getLogRecord(listenerClassName, cnfe));
        }
        catch (IllegalAccessException iae) {
            logger.log(this.getLogRecord(listenerClassName, iae));
        }
        catch (InstantiationException ie) {
            logger.log(this.getLogRecord(listenerClassName, ie));
        }
    }

    public PortletURLGenerationListener getListener() {
        return this.listener;
    }

    public List getDescriptions() {
        return new ArrayList<String>(this.descriptionMap.values());
    }

    public String getDescription() {
        return PortletXMLDocumentHelper.getDescription(this.descriptionMap);
    }

    public String getDescription(String lang) {
        return this.descriptionMap.get(lang);
    }

    public Map getDescriptionMap() {
        return this.descriptionMap;
    }

    private LogRecord getLogRecord(String message, Throwable cause) {
        LogRecord logRecord = new LogRecord(Level.WARNING, "PSPL_PCCCSPPCCD0017");
        logRecord.setLoggerName(logger.getName());
        logRecord.setParameters(new String[]{message});
        logRecord.setThrown(cause);
        return logRecord;
    }
}

