/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.bundle;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.logging.SilverLogger;

@Technical
public class ConfigurationClassLoader
extends ClassLoader {
    private final Path resourceRootPath;

    public ConfigurationClassLoader(Path resourcesRootPath, ClassLoader parent) {
        super(parent);
        this.resourceRootPath = resourcesRootPath;
    }

    @Override
    public synchronized void clearAssertionStatus() {
        super.clearAssertionStatus();
    }

    @Override
    public URL getResource(String name) {
        Path file;
        URL resource = super.getResource(name);
        if (resource == null && name != null && Files.exists(file = this.getPath(name), new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
            try {
                resource = file.toUri().toURL();
            }
            catch (MalformedURLException ex) {
                SilverLogger.getLogger(this).error("Malformed URL for resource " + name, ex);
            }
        }
        return resource;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        Path file;
        InputStream inputStream = super.getResourceAsStream(name);
        if (inputStream == null && name != null && Files.exists(file = this.getPath(name), new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
            try {
                inputStream = Files.newInputStream(file, new OpenOption[0]);
            }
            catch (FileNotFoundException e) {
                SilverLogger.getLogger(this).error("Resource " + name + " not found", e);
            }
            catch (IOException e) {
                SilverLogger.getLogger(this).error("Unexpected error while opening the resource " + name, e);
            }
        }
        return inputStream;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    @Override
    public synchronized void setClassAssertionStatus(String className, boolean enabled) {
        super.setClassAssertionStatus(className, enabled);
    }

    @Override
    public synchronized void setDefaultAssertionStatus(boolean enabled) {
        super.setDefaultAssertionStatus(enabled);
    }

    @Override
    public synchronized void setPackageAssertionStatus(String packageName, boolean enabled) {
        super.setPackageAssertionStatus(packageName, enabled);
    }

    private Path getPath(String name) {
        String relativePath = name.startsWith("/") ? name.substring(1) : name;
        return this.resourceRootPath.resolve(relativePath);
    }
}

