/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import com.sun.star.beans.XHierarchicalPropertySet;
import com.sun.star.beans.XHierarchicalPropertySetInfo;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.NamedThreadFactory;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeUtils;
import org.jodconverter.core.office.RetryTimeoutException;
import org.jodconverter.core.util.FileUtils;
import org.jodconverter.core.util.OSUtils;
import org.jodconverter.core.util.StringUtils;
import org.jodconverter.local.office.ConnectRetryable;
import org.jodconverter.local.office.ExistingProcessAction;
import org.jodconverter.local.office.ExitCodeRetryable;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.jodconverter.local.office.OfficeConnection;
import org.jodconverter.local.office.OfficeDescriptor;
import org.jodconverter.local.office.OfficeUrl;
import org.jodconverter.local.office.StartProcessAndConnectRetryable;
import org.jodconverter.local.office.VerboseProcess;
import org.jodconverter.local.office.utils.Info;
import org.jodconverter.local.office.utils.Lo;
import org.jodconverter.local.process.LinesPumpStreamHandler;
import org.jodconverter.local.process.ProcessManager;
import org.jodconverter.local.process.ProcessQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalOfficeProcessManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalOfficeProcessManager.class);
    private static final String PROP_PATH_USE_OPENGL = "VCL/UseOpenGL";
    private VerboseProcess process;
    private long pid = -1L;
    private OfficeDescriptor descriptor;
    private final OfficeConnection connection;
    private final ExecutorService executor;
    private final File instanceProfileDir;
    private final AtomicBoolean openglDisconnect = new AtomicBoolean(false);
    private final OfficeUrl officeUrl;
    private final File officeHome;
    private final ProcessManager processManager;
    private final List<String> runAsArgs;
    private final File templateProfileDir;
    private final long processTimeout;
    private final long processRetryInterval;
    private final long afterStartProcessDelay;
    private final ExistingProcessAction existingProcessAction;
    private final boolean startFailFast;
    private final boolean keepAliveOnShutdown;
    private final boolean disableOpengl;

    LocalOfficeProcessManager(OfficeUrl officeUrl, File officeHome, File workingDir, ProcessManager processManager, List<String> runAsArgs, File templateProfileDir, long processTimeout, long processRetryInterval, long afterStartProcessDelay, ExistingProcessAction existingProcessAction, boolean startFailFast, boolean keepAliveOnShutdown, boolean disableOpengl, OfficeConnection connection) {
        this.officeUrl = officeUrl;
        this.officeHome = officeHome;
        this.processManager = processManager;
        this.runAsArgs = runAsArgs;
        this.templateProfileDir = templateProfileDir;
        this.processTimeout = processTimeout;
        this.processRetryInterval = processRetryInterval;
        this.afterStartProcessDelay = afterStartProcessDelay;
        this.existingProcessAction = existingProcessAction;
        this.startFailFast = startFailFast;
        this.keepAliveOnShutdown = keepAliveOnShutdown;
        this.disableOpengl = disableOpengl;
        this.connection = connection;
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("jodconverter-offprocmng"));
        this.instanceProfileDir = new File(workingDir, ".jodconverter_" + officeUrl.getConnectString().replace(',', '_').replace('=', '-'));
    }

    OfficeConnection getConnection() {
        return this.connection;
    }

    void start() throws OfficeException {
        if (this.startFailFast) {
            LOGGER.debug("Submitting start task...");
            Future<Void> future = this.executor.submit(() -> this.startProcessAndConnect(false, true));
            try {
                LOGGER.debug("Waiting for start task to complete...");
                future.get();
                LOGGER.debug("Start task executed successfully.");
            }
            catch (ExecutionException ex) {
                throw this.handleStartTaskExecutionException(ex);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new OfficeException("Interruption while starting the office process.", (Throwable)ex);
            }
        } else {
            this.executor.execute(() -> {
                try {
                    this.startProcessAndConnect(false, true);
                }
                catch (OfficeException ex) {
                    LOGGER.error("Could not start the office process.", (Throwable)ex);
                }
            });
        }
    }

    private OfficeException handleStartTaskExecutionException(ExecutionException executionException) {
        if (executionException.getCause() instanceof OfficeException) {
            return (OfficeException)executionException.getCause();
        }
        return new OfficeException("Start task did not complete", executionException.getCause());
    }

    void restart() {
        LOGGER.info("Restarting...");
        this.executor.execute(() -> {
            this.stopProcess(false);
            try {
                this.startProcessAndConnect(true, false);
            }
            catch (OfficeException ex) {
                LOGGER.error("Could not restart the office process.", (Throwable)ex);
            }
        });
    }

    void restartDueToLostConnection() {
        LOGGER.info("Restarting due to lost connection...");
        this.executor.execute(() -> {
            if (this.openglDisconnect.compareAndSet(true, false)) {
                LOGGER.debug("Connection lost because OpenGL was changed");
                this.ensureProcessExited(false);
                try {
                    this.startProcessAndConnect(true, false);
                }
                catch (OfficeException ex) {
                    LOGGER.error("Could not restart the office process after disabling OpenGL.", (Throwable)ex);
                }
            } else {
                LOGGER.debug("Connection lost unexpectedly");
                this.ensureProcessExited(true);
                try {
                    this.startProcessAndConnect(false, true);
                }
                catch (OfficeException ex) {
                    LOGGER.error("Could not restart the office process after an unexpected lost connection.", (Throwable)ex);
                }
            }
        });
    }

    void restartDueToTaskTimeout() {
        LOGGER.info("Restarting due to task timeout...");
        this.forciblyTerminateProcess();
    }

    void stop() throws OfficeException {
        LOGGER.debug("Submitting stop task...");
        if (this.keepAliveOnShutdown) {
            this.executor.execute(this.connection::disconnect);
        } else {
            this.executor.execute(() -> this.stopProcess(true));
        }
        this.executor.shutdown();
        try {
            long stopTimeout = this.processTimeout + 1000L;
            LOGGER.debug("Waiting for stop task to complete ({} millisecs)...", (Object)stopTimeout);
            if (this.executor.awaitTermination(stopTimeout, TimeUnit.MILLISECONDS)) {
                LOGGER.debug("Stop task executed successfully.");
            } else {
                LOGGER.debug("Could not execute stop task within {} millisecs...", (Object)stopTimeout);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new OfficeException("Interruption while stopping the office process.", (Throwable)ex);
        }
    }

    private Void startProcessAndConnect(boolean restart, boolean checkOpengl) throws OfficeException {
        this.pid = -1L;
        this.process = null;
        this.detectOfficeDescriptor();
        String acceptString = this.officeUrl.getAcceptString();
        ProcessQuery processQuery = new ProcessQuery("soffice", acceptString);
        this.pid = this.checkForExistingProcess(processQuery);
        if (this.pid > -1L) {
            return null;
        }
        if (!restart) {
            this.prepareInstanceProfileDir();
        }
        this.executeStartProcessAndConnect(acceptString, processQuery);
        if (this.pid == -2L) {
            throw new OfficeException(String.format("A process with --accept '%s' started but its pid could not be found", acceptString));
        }
        this.handleOpenGlRestart(checkOpengl);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStartProcessAndConnect(String acceptString, ProcessQuery processQuery) throws OfficeException {
        ProcessBuilder processBuilder = this.prepareProcessBuilder(acceptString);
        LOGGER.debug("OFFICE HOME: {}", (Object)this.officeHome);
        LOGGER.info("Starting process with --accept '{}' and profileDir '{}'", (Object)acceptString, (Object)this.instanceProfileDir);
        try {
            StartProcessAndConnectRetryable retryable = new StartProcessAndConnectRetryable(this.processManager, processBuilder, processQuery, this.afterStartProcessDelay, this.connection);
            try {
                retryable.execute(this.processRetryInterval, this.processTimeout);
            }
            finally {
                this.process = retryable.getProcess();
                this.pid = retryable.getProcessId();
            }
            LOGGER.info("Started process; pid: {}", this.pid == -2L ? "PID_NOT_FOUND" : (this.pid == -1L ? "PID_UNKNOWN" : Long.valueOf(this.pid)));
        }
        catch (Exception ex) {
            throw new OfficeException(String.format("An error prevents us to start a process with --accept '%s'", acceptString), (Throwable)ex);
        }
    }

    private void handleOpenGlRestart(boolean checkOpengl) throws OfficeException {
        if (checkOpengl && this.disableOpengl && this.checkForOpengl(this.connection.getComponentContext())) {
            LOGGER.info("OpenGL has been disabled and a restart is required; restarting...");
            this.openglDisconnect.set(true);
            this.executor.execute(this::forciblyTerminateProcess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void stopProcess(boolean deleteInstanceProfileDir) {
        LOGGER.debug("Stopping the office process with deleteInstanceProfileDir set to {}...", (Object)deleteInstanceProfileDir);
        try {
            XDesktop desktop = this.connection.getDesktop();
            if (desktop == null) {
                this.forciblyTerminateProcess();
            } else {
                boolean terminated = this.connection.getDesktop().terminate();
                LOGGER.debug("The office process {}", (Object)(terminated ? "will be terminated shortly. A request has been sent to terminate the desktop." : "is still running. Someone else prevents termination, e.g. the quickstarter."));
            }
        }
        catch (DisposedException ex) {
            LOGGER.debug("Expected DisposedException catch and ignored in stopProcess", (Throwable)ex);
        }
        finally {
            this.ensureProcessExited(deleteInstanceProfileDir);
        }
        return null;
    }

    private void killExistingProcess(long pid, ProcessQuery processQuery) throws IOException, OfficeException {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("A process with --accept '{}' is already running; pid {}; trying to kill it...", (Object)processQuery.getArgument(), (Object)pid);
        }
        this.processManager.kill(null, pid);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (this.processManager.findPid(processQuery) > -1L) {
            throw new OfficeException(String.format("A process with --accept '%s' is already running and could not be killed; pid %d", processQuery.getArgument(), pid));
        }
    }

    private void connectToExistingProcess(long pid, String accept) throws OfficeException {
        LOGGER.debug("Connecting to existing process with --accept '{}'; pid {}", (Object)accept, (Object)pid);
        try {
            new ConnectRetryable(this.connection).execute(this.processRetryInterval, this.processTimeout);
        }
        catch (RetryTimeoutException ex) {
            throw new OfficeException(String.format("Could not establish connection to existing process with --accept '%s'; pid %d", accept, pid), (Throwable)ex);
        }
    }

    private long checkForExistingProcess(ProcessQuery processQuery) throws OfficeException {
        String accept = processQuery.getArgument();
        try {
            long pid = this.processManager.findPid(processQuery);
            if (pid <= -1L) {
                LOGGER.debug("Checking existing process done; no process running with --accept '{}'", (Object)accept);
                return pid;
            }
            switch (this.existingProcessAction) {
                case FAIL: {
                    throw new OfficeException(String.format("A process with --accept '%s' is already running; pid %d", accept, pid));
                }
                case KILL: {
                    this.killExistingProcess(pid, processQuery);
                    pid = -1L;
                    break;
                }
                case CONNECT: {
                    this.connectToExistingProcess(pid, accept);
                    break;
                }
                case CONNECT_OR_KILL: {
                    try {
                        this.connectToExistingProcess(pid, accept);
                        break;
                    }
                    catch (OfficeException ex) {
                        this.killExistingProcess(pid, processQuery);
                        pid = -1L;
                    }
                }
            }
            return pid;
        }
        catch (IOException ioEx) {
            throw new OfficeException(String.format("Could not check if there is already an existing process with --accept '%s'", accept), (Throwable)ioEx);
        }
    }

    private @NonNull ProcessBuilder prepareProcessBuilder(@NonNull String acceptString) {
        ArrayList<String> command = new ArrayList<String>(this.runAsArgs);
        File executable = LocalOfficeUtils.getOfficeExecutable(this.officeHome);
        String execPath = executable.getAbsolutePath();
        String prefix = this.descriptor.useLongOptionNameGnuStyle() ? "--" : "-";
        command.add(execPath);
        command.add(prefix + "accept=" + acceptString);
        command.add(prefix + "headless");
        command.add(prefix + "invisible");
        command.add(prefix + "nocrashreport");
        command.add(prefix + "nodefault");
        command.add(prefix + "nofirststartwizard");
        command.add(prefix + "nolockcheck");
        command.add(prefix + "nologo");
        command.add(prefix + "norestore");
        command.add("-env:UserInstallation=" + LocalOfficeUtils.toUrl(this.instanceProfileDir));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ProcessBuilder command: {}", (Object)String.join((CharSequence)" ", command));
        }
        return new ProcessBuilder(command);
    }

    private void detectOfficeDescriptor() {
        File executable = LocalOfficeUtils.getOfficeExecutable(this.officeHome);
        String execPath = executable.getAbsolutePath();
        this.descriptor = OfficeDescriptor.fromExecutablePath(execPath);
        if (OSUtils.IS_OS_WINDOWS) {
            return;
        }
        String prefix = this.descriptor.useLongOptionNameGnuStyle() ? "--" : "-";
        ArrayList<String> command = new ArrayList<String>(this.runAsArgs);
        command.add(execPath);
        command.add(prefix + "invisible");
        command.add(prefix + "help");
        command.add(prefix + "headless");
        command.add(prefix + "nocrashreport");
        command.add(prefix + "nodefault");
        command.add(prefix + "nofirststartwizard");
        command.add(prefix + "nolockcheck");
        command.add(prefix + "nologo");
        command.add(prefix + "norestore");
        command.add("-env:UserInstallation=" + LocalOfficeUtils.toUrl(this.instanceProfileDir));
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            Process process = processBuilder.start();
            LinesPumpStreamHandler handler = new LinesPumpStreamHandler(process.getInputStream(), process.getErrorStream());
            handler.start();
            try {
                process.waitFor();
                handler.stop();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.descriptor = OfficeDescriptor.fromHelpOutput(handler.getOutputPumper().getLines());
        }
        catch (IOException ioEx) {
            LOGGER.warn("An I/O error prevents us to determine office version", (Throwable)ioEx);
        }
    }

    private void forciblyTerminateProcess() {
        if (this.process == null && this.pid <= -1L) {
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Trying to forcibly terminate process: '{}'; pid: {}", (Object)this.officeUrl.getAcceptString(), this.pid == -2L ? "PID_NOT_FOUND" : (this.pid == -1L ? "PID_UNKNOWN" : Long.valueOf(this.pid)));
        }
        try {
            this.processManager.kill(this.process == null ? null : this.process.getProcess(), this.pid);
        }
        catch (IOException ex) {
            LOGGER.error("Could not forcibly terminate process", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureProcessExited(boolean deleteInstanceProfileDir) {
        try {
            int exitCode = 0;
            if (this.process != null) {
                ExitCodeRetryable retryable = new ExitCodeRetryable(this.process);
                retryable.execute(this.processRetryInterval, this.processTimeout);
                exitCode = retryable.getExitCode();
            }
            LOGGER.info("Process exited with code {}", (Object)exitCode);
        }
        catch (RetryTimeoutException ex) {
            LOGGER.error("Time out ensuring process exited", (Throwable)ex);
            this.forciblyTerminateProcess();
        }
        finally {
            if (deleteInstanceProfileDir) {
                this.deleteInstanceProfileDir();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkForOpengl(XComponentContext context) throws OfficeException {
        try {
            Object viewRoot = Info.getConfigUpdateAccess(context, "/org.openoffice.Office.Common");
            if (viewRoot == null) {
                return false;
            }
            try {
                XHierarchicalPropertySet properties = Lo.qi(XHierarchicalPropertySet.class, viewRoot);
                XHierarchicalPropertySetInfo propsInfo = properties.getHierarchicalPropertySetInfo();
                if (!propsInfo.hasPropertyByHierarchicalName(PROP_PATH_USE_OPENGL)) return false;
                boolean useOpengl = (Boolean)properties.getHierarchicalPropertyValue(PROP_PATH_USE_OPENGL);
                LOGGER.info("Use OpenGL is set to {}", (Object)useOpengl);
                if (!useOpengl) return false;
                properties.setHierarchicalPropertyValue(PROP_PATH_USE_OPENGL, (Object)false);
                XChangesBatch updateControl = Lo.qi(XChangesBatch.class, viewRoot);
                updateControl.commitChanges();
                boolean bl = true;
                return bl;
            }
            finally {
                Lo.qi(XComponent.class, viewRoot).dispose();
            }
        }
        catch (com.sun.star.uno.Exception ex) {
            throw new OfficeException("Could not check if the Use OpenGL option is on.", (Throwable)ex);
        }
    }

    private void prepareInstanceProfileDir() throws OfficeException {
        String property;
        File templateDir;
        if (this.instanceProfileDir.exists()) {
            LOGGER.warn("Profile dir '{}' already exists; deleting", (Object)this.instanceProfileDir);
            this.deleteInstanceProfileDir();
        }
        if ((templateDir = this.templateProfileDir) == null && StringUtils.isNotBlank((String)(property = System.getProperty("org.jodconverter.local.manager.templateProfileDir")))) {
            templateDir = new File(property);
        }
        if (templateDir != null) {
            try {
                FileUtils.copyDirectory((File)templateDir, (File)this.instanceProfileDir, (CopyOption[])new CopyOption[0]);
            }
            catch (IOException ioEx) {
                throw new OfficeException("Failed to create the instance profile directory", (Throwable)ioEx);
            }
        }
    }

    private void deleteInstanceProfileDir() {
        OfficeUtils.deleteOrRenameFile((File)this.instanceProfileDir, (long)250L, (long)1000L);
    }
}

