/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import java.io.UnsupportedEncodingException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ValueXMLhandler
extends LDAPXMLHandler {
    private boolean isBase64;

    public ValueXMLhandler(LDAPXMLHandler parent) {
        super("value", parent);
    }

    public ValueXMLhandler(String tagname, LDAPXMLHandler parent) {
        super(tagname, parent);
    }

    protected void endElement() {
        try {
            String name = this.getName();
            String value = this.getValue();
            byte[] temp = this.isBase64 ? Base64.decode(value) : value.getBytes("UTF-8");
            this.getParent().addValue(name, temp);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected void handleAttributes(Attributes attributes) throws SAXException {
        String temp = attributes.getValue("xsi:type");
        this.isBase64 = temp != null && temp.equals("xsd:base64Binary");
    }

    public static void parseInput(String whole, StringBuffer buffer) {
        int start = whole.indexOf(60);
        if (start != -1) {
            if (start > 0) {
                start = 0;
            }
            int end = whole.indexOf(62);
            String token = whole.substring(start, end + 1);
            buffer.append(token);
            String part = whole.substring(end + 1).trim();
            ValueXMLhandler.parseInput(part, buffer);
        }
    }

    public static String newLine(int indentTabs) {
        String tabString = "    ";
        String result = "\n";
        for (int i = 0; i < indentTabs; ++i) {
            result = result + tabString;
        }
        return result;
    }
}

