/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.time;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.core.notification.message.MessageManager;
import org.silverpeas.core.util.time.DurationConversionBoardKey;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.StringUtil;

enum DurationUnit {
    MILLI("ms"),
    SEC("s"),
    MIN("m"),
    HOUR("h"),
    DAY("d"),
    WEEK("w"),
    MONTH("M"),
    YEAR("y");

    private final String bundleDefault;
    private static final Map<DurationConversionBoardKey, BigDecimal> conversionBoard;

    private DurationUnit(String bundleDefault) {
        this.bundleDefault = bundleDefault;
    }

    protected String getBundleKey() {
        return this.name();
    }

    protected String getBundleDefault() {
        return this.bundleDefault;
    }

    public String getLabel() {
        return StringUtil.defaultStringIfNotDefined((String)DurationUnit.getStringTranslation(this.getBundleKey()), (String)this.getBundleDefault());
    }

    public BigDecimal getMultiplier(DurationUnit to) {
        return conversionBoard.get(new DurationConversionBoardKey(this, to));
    }

    private static String getStringTranslation(String key) {
        String language = MessageManager.getLanguage();
        LocalizationBundle localizedUnits = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.multilang.util", (String)language);
        return localizedUnits.getString(key);
    }

    static DurationUnit from(TimeUnit unit) {
        return DurationUnit.values()[unit.ordinal()];
    }

    static {
        conversionBoard = new HashMap<DurationConversionBoardKey, BigDecimal>();
        conversionBoard.put(new DurationConversionBoardKey(MILLI, SEC), new BigDecimal("1000"));
        conversionBoard.put(new DurationConversionBoardKey(MILLI, MIN), new BigDecimal("1000").multiply(new BigDecimal("60")));
        conversionBoard.put(new DurationConversionBoardKey(MILLI, HOUR), new BigDecimal("1000").multiply(new BigDecimal("60")).multiply(new BigDecimal("60")));
        conversionBoard.put(new DurationConversionBoardKey(MILLI, DAY), new BigDecimal("1000").multiply(new BigDecimal("60")).multiply(new BigDecimal("60")).multiply(new BigDecimal("24")));
        conversionBoard.put(new DurationConversionBoardKey(MILLI, WEEK), new BigDecimal("1000").multiply(new BigDecimal("60")).multiply(new BigDecimal("60")).multiply(new BigDecimal("24")).multiply(new BigDecimal("7")));
        conversionBoard.put(new DurationConversionBoardKey(MILLI, MONTH), new BigDecimal("1000").multiply(new BigDecimal("60")).multiply(new BigDecimal("60")).multiply(new BigDecimal("24")).multiply(new BigDecimal("365").divide(new BigDecimal("12"), 30, 5)));
        conversionBoard.put(new DurationConversionBoardKey(MILLI, YEAR), new BigDecimal("1000").multiply(new BigDecimal("60")).multiply(new BigDecimal("60")).multiply(new BigDecimal("24")).multiply(new BigDecimal("365")));
        conversionBoard.put(new DurationConversionBoardKey(SEC, MIN), new BigDecimal("60"));
        conversionBoard.put(new DurationConversionBoardKey(SEC, HOUR), new BigDecimal("60").multiply(new BigDecimal("60")));
        conversionBoard.put(new DurationConversionBoardKey(SEC, DAY), new BigDecimal("60").multiply(new BigDecimal("60")).multiply(new BigDecimal("24")));
        conversionBoard.put(new DurationConversionBoardKey(SEC, WEEK), new BigDecimal("60").multiply(new BigDecimal("60")).multiply(new BigDecimal("24")).multiply(new BigDecimal("7")));
        conversionBoard.put(new DurationConversionBoardKey(SEC, MONTH), new BigDecimal("60").multiply(new BigDecimal("60")).multiply(new BigDecimal("24")).multiply(new BigDecimal("365").divide(new BigDecimal("12"), 30, 5)));
        conversionBoard.put(new DurationConversionBoardKey(SEC, YEAR), new BigDecimal("60").multiply(new BigDecimal("60")).multiply(new BigDecimal("24")).multiply(new BigDecimal("365")));
        conversionBoard.put(new DurationConversionBoardKey(MIN, HOUR), new BigDecimal("60"));
        conversionBoard.put(new DurationConversionBoardKey(MIN, DAY), new BigDecimal("60").multiply(new BigDecimal("24")));
        conversionBoard.put(new DurationConversionBoardKey(MIN, WEEK), new BigDecimal("60").multiply(new BigDecimal("24")).multiply(new BigDecimal("7")));
        conversionBoard.put(new DurationConversionBoardKey(MIN, MONTH), new BigDecimal("60").multiply(new BigDecimal("24")).multiply(new BigDecimal("365").divide(new BigDecimal("12"), 30, 5)));
        conversionBoard.put(new DurationConversionBoardKey(MIN, YEAR), new BigDecimal("60").multiply(new BigDecimal("24")).multiply(new BigDecimal("365")));
        conversionBoard.put(new DurationConversionBoardKey(HOUR, DAY), new BigDecimal("24"));
        conversionBoard.put(new DurationConversionBoardKey(HOUR, WEEK), new BigDecimal("24").multiply(new BigDecimal("7")));
        conversionBoard.put(new DurationConversionBoardKey(HOUR, MONTH), new BigDecimal("24").multiply(new BigDecimal("365").divide(new BigDecimal("12"), 30, 5)));
        conversionBoard.put(new DurationConversionBoardKey(HOUR, YEAR), new BigDecimal("24").multiply(new BigDecimal("365")));
        conversionBoard.put(new DurationConversionBoardKey(DAY, WEEK), new BigDecimal("7"));
        conversionBoard.put(new DurationConversionBoardKey(DAY, MONTH), new BigDecimal("365").divide(new BigDecimal("12"), 30, 5));
        conversionBoard.put(new DurationConversionBoardKey(DAY, YEAR), new BigDecimal("365"));
        conversionBoard.put(new DurationConversionBoardKey(WEEK, MONTH), new BigDecimal("52").divide(new BigDecimal("12"), 30, 5));
        conversionBoard.put(new DurationConversionBoardKey(WEEK, YEAR), new BigDecimal("52"));
        conversionBoard.put(new DurationConversionBoardKey(MONTH, YEAR), new BigDecimal("12"));
    }
}

