/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class SecuritySettings {
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.util.security");
    private static final Registration registration = new Registration();

    private SecuritySettings() {
    }

    private static boolean isWebProtectionEnabled() {
        return settings.getBoolean("security.web.protection", false);
    }

    public static boolean isWebSqlInjectionSecurityEnabled() {
        return SecuritySettings.isWebProtectionEnabled() && settings.getBoolean("security.web.protection.injection.sql", false);
    }

    public static String skippedParametersAboutWebSqlInjectionSecurity() {
        return settings.getString("security.web.protection.injection.sql.skipped.parameters", "");
    }

    public static boolean isWebXssInjectionSecurityEnabled() {
        return SecuritySettings.isWebProtectionEnabled() && settings.getBoolean("security.web.protection.injection.xss", false);
    }

    public static String skippedParametersAboutWebXssInjectionSecurity() {
        return settings.getString("security.web.protection.injection.xss.skipped.parameters", "");
    }

    public static boolean isWebSecurityByTokensEnabled() {
        return SecuritySettings.isWebProtectionEnabled() && settings.getBoolean("security.web.protection.token", false);
    }

    public static boolean isSessionTokenRenewEnabled() {
        return SecuritySettings.isWebSecurityByTokensEnabled() && settings.getBoolean("security.web.protection.sessiontoken.renew", false);
    }

    public static boolean isStrictTransportSecurityEnabled() {
        return SecuritySettings.isWebProtectionEnabled() && settings.getLong("security.web.protection.httpsonly", 0L) > 0L;
    }

    public static long getStrictTransportSecurityExpirationTime() {
        return settings.getLong("security.web.protection.httpsonly", 0L);
    }

    public static List<String> getAllowedDomains() {
        String domains = settings.getString("security.web.protection.domain.allowed", "");
        ArrayList<String> allowedDomains = new ArrayList<String>();
        if (!domains.trim().isEmpty()) {
            allowedDomains.addAll(Arrays.asList(domains.split(", ")));
        }
        allowedDomains.addAll(SecuritySettings.registration().getDomainsInCORS());
        return allowedDomains;
    }

    public static boolean isWebContentInjectionSecurityEnabled() {
        return SecuritySettings.isWebProtectionEnabled() && settings.getBoolean("security.web.protection.injection.content", false);
    }

    public static String getAllowedDefaultSourcesInCSP() {
        return String.join((CharSequence)" ", SecuritySettings.registration().getDefaultSourcesInCSP());
    }

    public static String getAllowedScriptSourcesInCSP() {
        return settings.getString("security.web.protection.injection.content.scripts", "");
    }

    public static String getAllowedStyleSourcesInCSP() {
        return settings.getString("security.web.protection.injection.content.styles", "");
    }

    public static String getIFrameSandboxTagAttribute() {
        String sandbox = settings.getString("security.external.iframe.sandbox", "");
        Object tagAttribute = "";
        if (!"deactivated".equals(sandbox)) {
            tagAttribute = "sandbox=\"" + StringUtil.defaultStringIfNotDefined((String)sandbox) + "\"";
        }
        return tagAttribute;
    }

    public static Registration registration() {
        return registration;
    }

    public static class Registration {
        private static final String DEFAULT_SRC = "default-src";
        private static final String CORS = "cors";
        private Map<String, List<String>> settings = new ConcurrentHashMap<String, List<String>>();

        public void registerDefaultSourceInCSP(String sourceURL) {
            this.register(sourceURL, DEFAULT_SRC);
        }

        public void registerDomainInCORS(String domain) {
            this.register(domain, CORS);
        }

        private void register(String domain, String cors) {
            List list = this.settings.computeIfAbsent(cors, k -> new ArrayList());
            if (!list.contains(domain)) {
                list.add(domain);
            }
        }

        List<String> getDefaultSourcesInCSP() {
            return this.settings.getOrDefault(DEFAULT_SRC, Collections.emptyList());
        }

        List<String> getDomainsInCORS() {
            return this.settings.getOrDefault(CORS, Collections.emptyList());
        }
    }
}

