/*
 * Decompiled with CFR 0.152.
 */
package com.jacob.com;

import com.jacob.com.Currency;
import com.jacob.com.DateUtilities;
import com.jacob.com.Dispatch;
import com.jacob.com.EnumVariant;
import com.jacob.com.JacobException;
import com.jacob.com.JacobObject;
import com.jacob.com.NotImplementedException;
import com.jacob.com.SafeArray;
import com.jacob.com.VariantUtilities;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public class Variant
extends JacobObject {
    public static final Variant DEFAULT;
    public static final Variant VT_MISSING;
    public static final Variant VT_TRUE;
    public static final Variant VT_FALSE;
    public static final short VariantEmpty = 0;
    public static final short VariantNull = 1;
    public static final short VariantShort = 2;
    public static final short VariantInt = 3;
    public static final short VariantFloat = 4;
    public static final short VariantDouble = 5;
    public static final short VariantCurrency = 6;
    public static final short VariantDate = 7;
    public static final short VariantString = 8;
    public static final short VariantDispatch = 9;
    public static final short VariantError = 10;
    public static final short VariantBoolean = 11;
    public static final short VariantVariant = 12;
    public static final short VariantObject = 13;
    public static final short VariantDecimal = 14;
    public static final short VariantByte = 17;
    public static final short VariantLongInt = 20;
    public static final short VariantPointer = 26;
    public static final short VariantTypeMask = 4095;
    public static final short VariantArray = 8192;
    public static final short VariantByref = 16384;
    int m_pVariant = 0;

    public Variant() {
        this(null, false);
    }

    public Variant(boolean in) {
        this(new Boolean(in));
    }

    public Variant(byte in) {
        this(new Byte(in));
    }

    public Variant(double in) {
        this(new Double(in));
    }

    public Variant(float in) {
        this(new Float(in));
    }

    public Variant(int in) {
        this(new Integer(in));
    }

    public Variant(long in) {
        this(new Long(in));
    }

    public Variant(Object in) {
        this(in, false);
    }

    public Variant(Object pValueObject, boolean fByRef) {
        this.init();
        VariantUtilities.populateVariant(this, pValueObject, fByRef);
    }

    public Variant(short in) {
        this(new Short(in));
    }

    public Variant changeType(short in) {
        this.changeVariantType(in);
        return this;
    }

    private native void changeVariantType(short var1);

    public native Object clone();

    @Deprecated
    public native Variant cloneIndirect();

    protected void finalize() {
        this.safeRelease();
    }

    public boolean getBoolean() {
        if (this.getvt() == 11) {
            return this.getVariantBoolean();
        }
        throw new IllegalStateException("getBoolean() only legal on Variants of type VariantBoolean, not " + this.getvt());
    }

    public boolean getBooleanRef() {
        if ((this.getvt() & 0xFFF) == 11 && (this.getvt() & 0x4000) == 16384) {
            return this.getVariantBooleanRef();
        }
        throw new IllegalStateException("getBooleanRef() only legal on byRef Variants of type VariantBoolean, not " + this.getvt());
    }

    public byte getByte() {
        if (this.getvt() == 17) {
            return this.getVariantByte();
        }
        throw new IllegalStateException("getByte() only legal on Variants of type VariantByte, not " + this.getvt());
    }

    public byte getByteRef() {
        if ((this.getvt() & 0xFFF) == 17 && (this.getvt() & 0x4000) == 16384) {
            return this.getVariantByteRef();
        }
        throw new IllegalStateException("getByteRef() only legal on byRef Variants of type VariantByte, not " + this.getvt());
    }

    public Currency getCurrency() {
        if (this.getvt() == 6) {
            return new Currency(this.getVariantCurrency());
        }
        throw new IllegalStateException("getCurrency() only legal on Variants of type VariantCurrency, not " + this.getvt());
    }

    public Currency getCurrencyRef() {
        if ((this.getvt() & 0xFFF) == 6 && (this.getvt() & 0x4000) == 16384) {
            return new Currency(this.getVariantCurrencyRef());
        }
        throw new IllegalStateException("getCurrencyRef() only legal on byRef Variants of type VariantCurrency, not " + this.getvt());
    }

    public double getDate() {
        if (this.getvt() == 7) {
            return this.getVariantDate();
        }
        throw new IllegalStateException("getDate() only legal on Variants of type VariantDate, not " + this.getvt());
    }

    public double getDateRef() {
        if ((this.getvt() & 0xFFF) == 7 && (this.getvt() & 0x4000) == 16384) {
            return this.getVariantDateRef();
        }
        throw new IllegalStateException("getDateRef() only legal on byRef Variants of type VariantDate, not " + this.getvt());
    }

    public BigDecimal getDecimal() {
        if (this.getvt() == 14) {
            return (BigDecimal)this.getVariantDec();
        }
        throw new IllegalStateException("getDecimal() only legal on Variants of type VariantDecimal, not " + this.getvt());
    }

    public BigDecimal getDecimalRef() {
        if ((this.getvt() & 0xFFF) == 14 && (this.getvt() & 0x4000) == 16384) {
            return (BigDecimal)this.getVariantDecRef();
        }
        throw new IllegalStateException("getDecimalRef() only legal on byRef Variants of type VariantDecimal, not " + this.getvt());
    }

    public Dispatch getDispatch() {
        if (this.getvt() == 9) {
            return this.toDispatch();
        }
        throw new IllegalStateException("getDispatch() only legal on Variants of type VariantDispatch, not " + this.getvt());
    }

    public Dispatch getDispatchRef() {
        if ((this.getvt() & 0xFFF) == 9 && (this.getvt() & 0x4000) == 16384) {
            return this.toDispatch();
        }
        throw new IllegalStateException("getDispatchRef() only legal on byRef Variants of type VariantDispatch, not " + this.getvt());
    }

    public double getDouble() {
        if (this.getvt() == 5) {
            return this.getVariantDouble();
        }
        throw new IllegalStateException("getDouble() only legal on Variants of type VariantDouble, not " + this.getvt());
    }

    public double getDoubleRef() {
        if ((this.getvt() & 0xFFF) == 5 && (this.getvt() & 0x4000) == 16384) {
            return this.getVariantDoubleRef();
        }
        throw new IllegalStateException("getDoubleRef() only legal on byRef Variants of type VariantDouble, not " + this.getvt());
    }

    @Deprecated
    public void getEmpty() {
    }

    public int getError() {
        if (this.getvt() == 10) {
            return this.getVariantError();
        }
        throw new IllegalStateException("getError() only legal on Variants of type VariantError, not " + this.getvt());
    }

    public int getErrorRef() {
        if ((this.getvt() & 0xFFF) == 10 && (this.getvt() & 0x4000) == 16384) {
            return this.getVariantErrorRef();
        }
        throw new IllegalStateException("getErrorRef() only legal on byRef Variants of type VariantError, not " + this.getvt());
    }

    public float getFloat() {
        if (this.getvt() == 4) {
            return this.getVariantFloat();
        }
        throw new IllegalStateException("getFloat() only legal on Variants of type VariantFloat, not " + this.getvt());
    }

    public float getFloatRef() {
        if ((this.getvt() & 0xFFF) == 4 && (this.getvt() & 0x4000) == 16384) {
            return this.getVariantFloatRef();
        }
        throw new IllegalStateException("getFloatRef() only legal on byRef Variants of type VariantFloat, not " + this.getvt());
    }

    public int getInt() {
        if (this.getvt() == 3) {
            return this.getVariantInt();
        }
        if (this.getvt() == 2) {
            return this.getVariantShort();
        }
        throw new IllegalStateException("getInt() only legal on Variants of type VariantInt, not " + this.getvt());
    }

    public int getIntRef() {
        if ((this.getvt() & 0xFFF) == 3 && (this.getvt() & 0x4000) == 16384) {
            return this.getVariantIntRef();
        }
        throw new IllegalStateException("getIntRef() only legal on byRef Variants of type VariantInt, not " + this.getvt());
    }

    public Date getJavaDate() {
        Date returnDate = null;
        if (this.getvt() == 7) {
            double windowsDate = this.getDate();
            if (windowsDate != 0.0) {
                returnDate = DateUtilities.convertWindowsTimeToDate(this.getDate());
            }
        } else {
            throw new IllegalStateException("getJavaDate() only legal on Variants of type VariantDate, not " + this.getvt());
        }
        return returnDate;
    }

    public Date getJavaDateRef() {
        double windowsDate = this.getDateRef();
        if (windowsDate == 0.0) {
            return null;
        }
        return DateUtilities.convertWindowsTimeToDate(windowsDate);
    }

    public long getLong() {
        if (this.getvt() == 20) {
            return this.getVariantLong();
        }
        throw new IllegalStateException("getLong() only legal on Variants of type VariantLongInt, not " + this.getvt());
    }

    public long getLongRef() {
        if ((this.getvt() & 0xFFF) == 20 && (this.getvt() & 0x4000) == 16384) {
            return this.getVariantLongRef();
        }
        throw new IllegalStateException("getLongRef() only legal on byRef Variants of type VariantLongInt, not " + this.getvt());
    }

    @Deprecated
    public void getNull() {
    }

    public short getShort() {
        if (this.getvt() == 2) {
            return this.getVariantShort();
        }
        throw new IllegalStateException("getShort() only legal on Variants of type VariantShort, not " + this.getvt());
    }

    public short getShortRef() {
        if ((this.getvt() & 0xFFF) == 2 && (this.getvt() & 0x4000) == 16384) {
            return this.getVariantShortRef();
        }
        throw new IllegalStateException("getShortRef() only legal on byRef Variants of type VariantShort, not " + this.getvt());
    }

    public String getString() {
        if (this.getvt() == 8) {
            return this.getVariantString();
        }
        if (this.getvt() == 0) {
            return null;
        }
        if (this.getvt() == 1) {
            return null;
        }
        throw new IllegalStateException("getString() only legal on Variants of type VariantString, not " + this.getvt());
    }

    public String getStringRef() {
        if ((this.getvt() & 0xFFF) == 8 && (this.getvt() & 0x4000) == 16384) {
            return this.getVariantStringRef();
        }
        throw new IllegalStateException("getStringRef() only legal on byRef Variants of type VariantString, not " + this.getvt());
    }

    public Object getVariant() {
        if ((this.getvt() & 0xFFF) == 12 && (this.getvt() & 0x4000) == 16384) {
            int enclosedVariantMemory;
            if (JacobObject.isDebugEnabled()) {
                JacobObject.debug("About to call getVariantVariant()");
            }
            Variant enclosedVariant = new Variant();
            enclosedVariant.m_pVariant = enclosedVariantMemory = this.getVariantVariant();
            Object enclosedVariantAsJava = enclosedVariant.toJavaObject();
            if (JacobObject.isDebugEnabled()) {
                JacobObject.debug("Zeroing out enclosed Variant's ref to windows memory");
            }
            enclosedVariant.m_pVariant = 0;
            return enclosedVariantAsJava;
        }
        throw new IllegalStateException("getVariant() only legal on Variants of type VariantVariant, not " + this.getvt());
    }

    @Deprecated
    public Variant[] getVariantArray() {
        throw new NotImplementedException("Not implemented");
    }

    @Deprecated
    public Variant[] getVariantArrayRef() {
        throw new NotImplementedException("Not implemented");
    }

    private native boolean getVariantBoolean();

    private native boolean getVariantBooleanRef();

    private native byte getVariantByte();

    private native byte getVariantByteRef();

    private native long getVariantCurrency();

    private native long getVariantCurrencyRef();

    private native double getVariantDate();

    private native double getVariantDateRef();

    private native Object getVariantDec();

    private native Object getVariantDecRef();

    private native double getVariantDouble();

    private native double getVariantDoubleRef();

    private native int getVariantError();

    private native int getVariantErrorRef();

    private native float getVariantFloat();

    private native float getVariantFloatRef();

    private native int getVariantInt();

    private native int getVariantIntRef();

    private native long getVariantLong();

    private native long getVariantLongRef();

    private native short getVariantShort();

    private native short getVariantShortRef();

    private native String getVariantString();

    private native String getVariantStringRef();

    private native short getVariantType();

    private native int getVariantVariant();

    public short getvt() {
        if (this.m_pVariant != 0) {
            return this.getVariantType();
        }
        throw new IllegalStateException("uninitialized Variant");
    }

    protected native void init();

    public boolean isNull() {
        this.getvt();
        return this.isVariantConsideredNull();
    }

    private native boolean isVariantConsideredNull();

    @Deprecated
    public void noParam() {
        this.putNoParam();
    }

    protected boolean objectIsAConstant(Variant pVariant) {
        return pVariant == VT_FALSE || pVariant == VT_TRUE || pVariant == VT_MISSING || pVariant == DEFAULT;
    }

    public void putBoolean(boolean in) {
        this.getvt();
        this.putVariantBoolean(in);
    }

    public void putBooleanRef(boolean in) {
        this.getvt();
        this.putVariantBooleanRef(in);
    }

    public void putByte(byte in) {
        this.getvt();
        this.putVariantByte(in);
    }

    @Deprecated
    public void putByteArray(Object in) {
        throw new NotImplementedException("Not implemented");
    }

    public void putByteRef(byte in) {
        this.getvt();
        this.putVariantByteRef(in);
    }

    @Deprecated
    public void putCharArray(Object in) {
        throw new NotImplementedException("Not implemented");
    }

    public void putCurrency(Currency in) {
        this.getvt();
        this.putVariantCurrency(in.longValue());
    }

    public void putCurrencyRef(Currency in) {
        this.getvt();
        this.putVariantCurrencyRef(in.longValue());
    }

    public void putDate(Date inDate) {
        if (inDate == null) {
            throw new IllegalArgumentException("Cannot put null in as windows date");
        }
        this.putDate(DateUtilities.convertDateToWindowsTime(inDate));
    }

    public void putDate(double in) {
        this.getvt();
        this.putVariantDate(in);
    }

    public void putDateRef(Date inDate) {
        if (inDate == null) {
            throw new IllegalArgumentException("Cannot put null in as windows date");
        }
        this.putDateRef(DateUtilities.convertDateToWindowsTime(inDate));
    }

    public void putDateRef(double in) {
        this.getvt();
        this.putVariantDateRef(in);
    }

    private void putDecimal(BigDecimal in, boolean byRef) {
        this.getvt();
        VariantUtilities.validateDecimalMinMax(in);
        BigInteger allWordBigInt = in.unscaledValue();
        VariantUtilities.validateDecimalScaleAndBits(in);
        int sign = in.signum();
        if (in.signum() < 0) {
            in = in.negate();
        }
        allWordBigInt = in.unscaledValue();
        byte scale = (byte)in.scale();
        int lowWord = allWordBigInt.intValue();
        BigInteger middleWordBigInt = allWordBigInt.shiftRight(32);
        int middleWord = middleWordBigInt.intValue();
        BigInteger highWordBigInt = allWordBigInt.shiftRight(64);
        int highWord = highWordBigInt.intValue();
        if (byRef) {
            this.putVariantDecRef(sign, scale, lowWord, middleWord, highWord);
        } else {
            this.putVariantDec(sign, scale, lowWord, middleWord, highWord);
        }
    }

    public void putDecimal(BigDecimal in) {
        this.putDecimal(in, false);
    }

    public void putDecimalRef(BigDecimal in) {
        this.putDecimal(in, true);
    }

    public void putDispatch(Dispatch in) {
        this.putVariantDispatch(in);
    }

    public void putDispatchRef(Dispatch in) {
        this.putVariantDispatch(in);
    }

    public void putDouble(double in) {
        this.getvt();
        this.putVariantDouble(in);
    }

    public void putDoubleRef(double in) {
        this.getvt();
        this.putVariantDoubleRef(in);
    }

    public void putEmpty() {
        this.getvt();
        this.putVariantEmpty();
    }

    public void putError(int in) {
        this.getvt();
        this.putVariantError(in);
    }

    public void putErrorRef(int in) {
        this.getvt();
        this.putVariantErrorRef(in);
    }

    public void putFloat(float in) {
        this.getvt();
        this.putVariantFloat(in);
    }

    public void putFloatRef(float in) {
        this.getvt();
        this.putVariantFloatRef(in);
    }

    public void putInt(int in) {
        this.getvt();
        this.putVariantInt(in);
    }

    public void putIntRef(int in) {
        this.getvt();
        this.putVariantIntRef(in);
    }

    public void putLong(long in) {
        this.getvt();
        this.putVariantLong(in);
    }

    public void putLongRef(long in) {
        this.getvt();
        this.putVariantLongRef(in);
    }

    public void putNoParam() {
        this.getvt();
        this.putVariantNoParam();
    }

    public void putNothing() {
        this.getvt();
        this.putVariantNothing();
    }

    public void putNull() {
        this.getvt();
        this.putVariantNull();
    }

    @Deprecated
    public void putObject(Object in) {
        this.putVariantDispatch(in);
    }

    @Deprecated
    public void putObjectRef(Object in) {
        this.putObject(in);
    }

    public void putSafeArray(SafeArray in) {
        this.getvt();
        this.putVariantSafeArray(in);
    }

    public void putSafeArrayRef(SafeArray in) {
        this.getvt();
        this.putVariantSafeArrayRef(in);
    }

    public void putShort(short in) {
        this.getvt();
        this.putVariantShort(in);
    }

    public void putShortRef(short in) {
        this.getvt();
        this.putVariantShortRef(in);
    }

    public void putString(String in) {
        this.getvt();
        this.putVariantString(in);
    }

    public void putStringRef(String in) {
        this.getvt();
        this.putVariantStringRef(in);
    }

    public void putVariant(Object objectToBeWrapped) {
        if (objectToBeWrapped == null) {
            throw new IllegalArgumentException("Cannot put null in as a variant");
        }
        if (objectToBeWrapped instanceof Variant) {
            throw new IllegalArgumentException("Cannot putVariant() only accepts non jacob objects.");
        }
        Variant inVariant = new Variant(objectToBeWrapped);
        this.putVariantVariant(inVariant);
        if (JacobObject.isDebugEnabled()) {
            JacobObject.debug("Zeroing out enclosed Variant's ref to windows memory");
        }
        inVariant.m_pVariant = 0;
    }

    @Deprecated
    public void putVariantArray(Variant[] in) {
        throw new NotImplementedException("Not implemented");
    }

    @Deprecated
    public void putVariantArrayRef(Variant[] in) {
        throw new NotImplementedException("Not implemented");
    }

    private native void putVariantBoolean(boolean var1);

    private native void putVariantBooleanRef(boolean var1);

    private native void putVariantByte(byte var1);

    private native void putVariantByteRef(byte var1);

    private native void putVariantCurrency(long var1);

    private native void putVariantCurrencyRef(long var1);

    private native void putVariantDate(double var1);

    private native void putVariantDateRef(double var1);

    private native void putVariantDec(int var1, byte var2, int var3, int var4, int var5);

    private native void putVariantDecRef(int var1, byte var2, int var3, int var4, int var5);

    private native void putVariantDispatch(Object var1);

    private native void putVariantDouble(double var1);

    private native void putVariantDoubleRef(double var1);

    private native void putVariantEmpty();

    private native void putVariantError(int var1);

    private native void putVariantErrorRef(int var1);

    private native void putVariantFloat(float var1);

    private native void putVariantFloatRef(float var1);

    private native void putVariantInt(int var1);

    private native void putVariantIntRef(int var1);

    private native void putVariantLong(long var1);

    private native void putVariantLongRef(long var1);

    private native void putVariantNoParam();

    private native void putVariantNothing();

    private native void putVariantNull();

    private native void putVariantSafeArray(SafeArray var1);

    private native void putVariantSafeArrayRef(SafeArray var1);

    private native void putVariantShort(short var1);

    private native void putVariantShortRef(short var1);

    private native void putVariantString(String var1);

    private native void putVariantStringRef(String var1);

    private native void putVariantVariant(Variant var1);

    private native void release();

    public void safeRelease() {
        if (!this.objectIsAConstant(this)) {
            super.safeRelease();
            if (this.m_pVariant != 0) {
                this.release();
                this.m_pVariant = 0;
            } else if (Variant.isDebugEnabled()) {
                Variant.debug("Variant: " + this.hashCode() + " double release");
            }
        } else if (Variant.isDebugEnabled()) {
            Variant.debug("Variant: " + this.hashCode() + " don't want to release a constant");
        }
    }

    protected native void SerializationReadFromBytes(byte[] var1);

    protected native byte[] SerializationWriteToBytes();

    @Deprecated
    public boolean toBoolean() {
        this.changeType((short)11);
        return this.getBoolean();
    }

    @Deprecated
    public byte toByte() {
        this.changeType((short)17);
        return this.getByte();
    }

    @Deprecated
    public Object toByteArray() {
        throw new NotImplementedException("Not implemented");
    }

    @Deprecated
    public Object toCharArray() {
        throw new NotImplementedException("Not implemented");
    }

    @Deprecated
    public Currency toCurrency() {
        this.changeType((short)6);
        return this.getCurrency();
    }

    @Deprecated
    public double toDate() {
        this.changeType((short)7);
        return this.getDate();
    }

    public Dispatch toDispatch() {
        return this.toVariantDispatch();
    }

    @Deprecated
    public double toDouble() {
        this.changeType((short)5);
        return this.getDouble();
    }

    public native EnumVariant toEnumVariant();

    @Deprecated
    public int toError() {
        this.changeType((short)10);
        return this.getError();
    }

    @Deprecated
    public float toFloat() {
        this.changeType((short)4);
        return this.getFloat();
    }

    @Deprecated
    public int toInt() {
        this.changeType((short)3);
        return this.getInt();
    }

    @Deprecated
    public Date toJavaDate() {
        this.changeType((short)7);
        return this.getJavaDate();
    }

    public Object toJavaObject() throws JacobException {
        return VariantUtilities.variantToObject(this);
    }

    @Deprecated
    public Object toObject() {
        return this.toDispatch();
    }

    public SafeArray toSafeArray() {
        this.getvt();
        return this.toSafeArray(true);
    }

    public SafeArray toSafeArray(boolean deepCopy) {
        this.getvt();
        return this.toVariantSafeArray(deepCopy);
    }

    @Deprecated
    public Object toScriptObject() {
        return this.toDispatch();
    }

    @Deprecated
    public short toShort() {
        this.changeType((short)2);
        return this.getShort();
    }

    public String toString() {
        try {
            this.getvt();
        }
        catch (IllegalStateException ise) {
            return "";
        }
        if (this.getvt() == 0 || this.getvt() == 10 || this.getvt() == 1) {
            return "null";
        }
        if (this.getvt() == 8) {
            return this.getString();
        }
        try {
            Object foo = this.toJavaObject();
            return foo.toString();
        }
        catch (NotImplementedException nie) {
            return "Description not available for type: " + this.getvt();
        }
    }

    @Deprecated
    public Variant toVariant() {
        return this;
    }

    @Deprecated
    public Variant[] toVariantArray() {
        throw new NotImplementedException("Not implemented");
    }

    private native Dispatch toVariantDispatch();

    private native SafeArray toVariantSafeArray(boolean var1);

    public native void VariantClear();

    static {
        VT_TRUE = new Variant(true);
        VT_FALSE = new Variant(false);
        Variant vtMissing = new Variant();
        vtMissing.putVariantNoParam();
        DEFAULT = vtMissing;
        VT_MISSING = vtMissing;
    }
}

