/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.List;
import org.springframework.social.linkedin.api.CodeAndName;
import org.springframework.social.linkedin.api.Company;
import org.springframework.social.linkedin.api.impl.json.DeserializationUtils;
import org.springframework.social.linkedin.api.impl.json.LinkedInObjectMixin;
import org.springframework.social.linkedin.api.impl.json.StringListDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class CompanyMixin
extends LinkedInObjectMixin {
    @JsonProperty(value="industry")
    String industry;
    @JsonProperty(value="size")
    String size;
    @JsonProperty(value="type")
    String type;
    @JsonProperty
    String blogRssUrl;
    @JsonProperty
    CodeAndName companyType;
    @JsonProperty
    String description;
    @JsonProperty
    @JsonDeserialize(using=StringListDeserializer.class)
    List<String> emailDomains;
    @JsonProperty
    CodeAndName employeeCountRange;
    @JsonProperty
    int foundedYear;
    @JsonProperty
    @JsonDeserialize(using=CompanyLocationListDeserializer.class)
    List<Company.CompanyLocation> locations;
    @JsonProperty
    String logoUrl;
    @JsonProperty
    int numFollowers;
    @JsonProperty
    @JsonDeserialize(using=StringListDeserializer.class)
    List<String> specialties;
    @JsonProperty
    String squareLogoUrl;
    @JsonProperty
    CodeAndName status;
    @JsonProperty
    CodeAndName stockExchange;
    @JsonProperty
    String ticker;
    @JsonProperty
    String twitterId;
    @JsonProperty
    String universalName;
    @JsonProperty
    String websiteUrl;

    @JsonCreator
    CompanyMixin(@JsonProperty(value="id") int id, @JsonProperty(value="name") String name) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompanyLocationListDeserializer
    extends JsonDeserializer<List<Company.CompanyLocation>> {
        private CompanyLocationListDeserializer() {
        }

        public List<Company.CompanyLocation> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<Company.CompanyLocation>>(){});
        }
    }
}

