/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.server.impl.browser.MultipartParser;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.apache.chemistry.opencmis.server.shared.QueryStringHttpServletRequestWrapper;
import org.apache.chemistry.opencmis.server.shared.TempStoreOutputStreamFactory;

public final class POSTHttpServletRequestWrapper
extends QueryStringHttpServletRequestWrapper {
    public static final String FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final int MAX_CONTENT_BYTES = 0xA00000;
    private static final int BUFFER_SIZE = 65536;
    private static final String CHARSET_FIELD = "_charset_";
    private String filename;
    private String contentType;
    private BigInteger size;
    private InputStream stream;

    public POSTHttpServletRequestWrapper(HttpServletRequest request, TempStoreOutputStreamFactory streamFactory) throws IOException {
        super(request);
        if (MultipartParser.isMultipartContent(request)) {
            String contentTypeControl;
            MultipartParser parser = new MultipartParser(request, streamFactory);
            parser.parse();
            if (parser.hasContent()) {
                this.filename = parser.getFilename();
                this.contentType = parser.getContentType();
                this.size = parser.getSize();
                this.stream = parser.getStream();
            }
            for (Map.Entry<String, String[]> e : parser.getFields().entrySet()) {
                this.addParameter(e.getKey(), e.getValue());
            }
            String filenameControl = HttpUtils.getStringParameter((HttpServletRequest)this, "filename");
            if (filenameControl != null && filenameControl.trim().length() > 0) {
                this.filename = filenameControl;
            }
            if ((contentTypeControl = HttpUtils.getStringParameter((HttpServletRequest)this, "contenttype")) != null && contentTypeControl.trim().length() > 0) {
                this.contentType = contentTypeControl;
            }
        } else if (POSTHttpServletRequestWrapper.isFormUrlencodedContent(request)) {
            if (!this.parseFormUrlEncodedData(request)) {
                this.parameters.putAll(request.getParameterMap());
            }
        } else {
            throw new CmisInvalidArgumentException("Invalid form encoding!");
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BigInteger getSize() {
        return this.size;
    }

    public InputStream getStream() {
        return this.stream;
    }

    protected boolean parseFormUrlEncodedData(HttpServletRequest request) throws IOException {
        String contentType;
        int b;
        byte[] data = new byte[65536];
        int dataPos = 0;
        ServletInputStream stream = request.getInputStream();
        byte[] buffer = new byte[65536];
        while ((b = stream.read(buffer)) != -1) {
            if (dataPos + b > 0xA00000) {
                throw new CmisInvalidArgumentException("Limit exceeded!");
            }
            if (data.length - dataPos < b) {
                int newSize = (data.length + b) * 2 < 0xA00000 ? data.length + b * 2 : 0xA00000;
                byte[] newbuf = new byte[newSize];
                System.arraycopy(data, 0, newbuf, 0, dataPos);
                data = newbuf;
            }
            System.arraycopy(buffer, 0, data, dataPos, b);
            dataPos += b;
        }
        if (dataPos == 0) {
            return false;
        }
        boolean parseName = true;
        boolean parseCharset = false;
        int startPos = 0;
        ArrayList<String[]> rawParameters = new ArrayList<String[]>();
        String rawName = null;
        String rawValue = null;
        String charset = null;
        block5: for (int i = 0; i < dataPos; ++i) {
            switch (data[i]) {
                case 61: {
                    if (startPos < i && CHARSET_FIELD.equalsIgnoreCase(rawName = new String(data, startPos, i - startPos, "ISO-8859-1"))) {
                        parseCharset = true;
                    }
                    parseName = false;
                    startPos = i + 1;
                    continue block5;
                }
                case 38: {
                    if (parseName) {
                        if (startPos < i) {
                            rawName = new String(data, startPos, i - startPos, "ISO-8859-1");
                            rawParameters.add(new String[]{rawName, null});
                        }
                    } else if (rawName != null) {
                        rawValue = new String(data, startPos, i - startPos, "ISO-8859-1");
                        rawParameters.add(new String[]{rawName, rawValue});
                        if (parseCharset) {
                            charset = rawValue;
                        }
                    }
                    rawName = null;
                    rawValue = null;
                    parseName = true;
                    parseCharset = false;
                    startPos = i + 1;
                    continue block5;
                }
            }
        }
        if (startPos < dataPos) {
            if (parseName) {
                rawName = new String(data, startPos, dataPos - startPos, "ISO-8859-1");
                rawParameters.add(new String[]{rawName, null});
            } else if (rawName != null) {
                rawValue = new String(data, startPos, dataPos - startPos, "ISO-8859-1");
                rawParameters.add(new String[]{rawName, rawValue});
                if (parseCharset) {
                    charset = rawValue;
                }
            }
        } else if (!parseName) {
            rawParameters.add(new String[]{rawName, ""});
        }
        data = null;
        if (charset == null && (contentType = request.getContentType()) != null) {
            String[] parts = contentType.split(";");
            for (int i = 1; i < parts.length; ++i) {
                String part = parts[i].trim().toLowerCase(Locale.ENGLISH);
                if (!part.startsWith("charset")) continue;
                int x = part.indexOf(61);
                charset = part.substring(x + 1).trim();
                break;
            }
        }
        if (charset == null) {
            charset = "UTF-8";
        }
        for (String[] rawParameter : rawParameters) {
            String name = URLDecoder.decode(rawParameter[0], charset);
            String value = null;
            if (rawParameter[1] != null) {
                value = URLDecoder.decode(rawParameter[1], charset);
            }
            this.addParameter(name, value);
        }
        return true;
    }

    public static final boolean isFormUrlencodedContent(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase(Locale.ENGLISH).startsWith(FORM_URLENCODED);
    }
}

