/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.CharEncoding;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.kernel.util.StringUtil;

public class EncodingUtil
extends StringUtils {
    private static final char[] PUNCTUATION = new char[]{'&', '\"', '\'', '{', '(', '[', '-', '|', '`', '_', '\\', '^', '@', ')', ']', '=', '+', '}', '?', ',', '.', ';', '/', ':', '!', '\u00a7', '%', '*', '$', '\u00a3', '\u20ac', '\u00a9', '\u00b2', '\u00b0', '\u00a4'};

    public static String detectStringEncoding(byte[] data, String declaredEncoding) throws UnsupportedEncodingException {
        String value;
        if (data != null && EncodingUtil.hasEncodingToBeChecked(value = new String(data, declaredEncoding))) {
            return EncodingUtil.findBestEncoding(data, declaredEncoding);
        }
        return declaredEncoding;
    }

    private static boolean hasEncodingToBeChecked(String value) {
        if (value != null) {
            char[] chars;
            for (char currentChar : chars = value.toCharArray()) {
                if (Character.isLetterOrDigit(currentChar) || Character.isWhitespace(currentChar) || ArrayUtils.contains((char[])PUNCTUATION, (char)currentChar)) continue;
                return true;
            }
        }
        return false;
    }

    private static String findBestEncoding(byte[] data, String declaredEncoding) throws UnsupportedEncodingException {
        Set<String> supportedEncodings = CharEncoding.UTF_8.equals(declaredEncoding) ? EncodingUtil.detectMaybeEncoding(data, CharEncoding.ISO_8859_1) : EncodingUtil.detectMaybeEncoding(data, CharEncoding.UTF_8);
        for (String encoding : supportedEncodings) {
            String encodedData = new String(data, encoding);
            if (EncodingUtil.hasEncodingToBeChecked(encodedData)) continue;
            return encoding;
        }
        return declaredEncoding;
    }

    private static Set<String> detectMaybeEncoding(byte[] data, String declaredEncoding) {
        CharsetDetector detector = new CharsetDetector();
        if (!StringUtil.isDefined((String)declaredEncoding)) {
            detector.setDeclaredEncoding(CharEncoding.ISO_8859_1);
        } else {
            detector.setDeclaredEncoding(declaredEncoding);
        }
        detector.setText(data);
        CharsetMatch[] detectedEnc = detector.detectAll();
        LinkedHashSet<String> encodings = new LinkedHashSet<String>(detectedEnc.length);
        for (CharsetMatch detectedEncoding : detectedEnc) {
            encodings.add(detectedEncoding.getName());
        }
        return encodings;
    }

    public static byte[] fromHex(String hexText) throws ParseException {
        try {
            return Hex.decodeHex((char[])hexText.toCharArray());
        }
        catch (Exception ex) {
            throw new ParseException(ex.getMessage(), -1);
        }
    }

    public static String asHex(byte[] binaryData) {
        return Hex.encodeHexString((byte[])binaryData);
    }

    private EncodingUtil() {
    }
}

