/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.encryption;

import java.util.concurrent.Semaphore;
import org.silverpeas.core.security.encryption.cipher.CryptoException;

class ConcurrentEncryptionTaskExecutor {
    private static final int TOKEN_COUNT = Integer.MAX_VALUE;
    private static final Semaphore semaphore = new Semaphore(Integer.MAX_VALUE);

    ConcurrentEncryptionTaskExecutor() {
    }

    public static <T> T execute(ConcurrentEncryptionTask<T> task) throws CryptoException {
        try {
            ConcurrentEncryptionTaskExecutor.acquireMutex();
            T t = task.execute();
            return t;
        }
        finally {
            ConcurrentEncryptionTaskExecutor.releaseMutex();
        }
    }

    private static synchronized void acquireMutex() {
        if (semaphore.availablePermits() == 0) {
            throw new IllegalStateException("The encryption is being updated: the content encryption and decryption service is blocked");
        }
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    private static synchronized void releaseMutex() {
        semaphore.release();
    }

    public static interface ConcurrentEncryptionTask<T> {
        public boolean isPrivileged();

        public T execute() throws CryptoException;
    }
}

