/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user;

import java.util.List;
import java.util.stream.Collectors;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.attachment.AttachmentService;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.FileLink;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.memory.MemoryUnit;
import org.silverpeas.kernel.util.StringUtil;

public class AttachmentLink
extends FileLink {
    private final String language;

    public static List<AttachmentLink> getForContribution(ResourceReference resource, String language) {
        AttachmentService attachmentService = AttachmentService.get();
        return attachmentService.listDocumentsByForeignKey(resource, language).stream().map(d -> {
            String label = StringUtil.isDefined((String)d.getTitle()) ? d.getTitle() : d.getFilename();
            return new AttachmentLink(URLUtil.getCurrentServerURL() + d.getUniversalURL(), label, d.getSize(), language);
        }).collect(Collectors.toList());
    }

    public AttachmentLink(String linkUrl, String linkLabel, long linkSize, String language) {
        super(linkUrl, linkLabel, linkSize);
        this.language = language == null ? DisplayI18NHelper.getDefaultLanguage() : language;
    }

    public String getFormattedLinkSize() {
        return this.formatFileSize(this.getLinkSize(), this.language);
    }

    private String formatFileSize(long size, String language) {
        String unit;
        long divider;
        if (size >= MemoryUnit.MB.getLimit().longValue()) {
            divider = MemoryUnit.MB.getLimit().longValue();
            unit = MemoryUnit.GB.getLabel(language);
        } else if (size >= MemoryUnit.KB.getLimit().longValue()) {
            divider = MemoryUnit.KB.getLimit().longValue();
            unit = MemoryUnit.MB.getLabel(language);
        } else if (size >= MemoryUnit.B.getLimit().longValue()) {
            divider = MemoryUnit.B.getLimit().longValue();
            unit = MemoryUnit.KB.getLabel(language);
        } else {
            divider = 1L;
            unit = MemoryUnit.B.getLabel(language);
        }
        return size / divider + " " + unit;
    }
}

