/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.dao.SqlUserSelectorByCriteriaBuilder;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserDetailsSearchCriteria;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.util.MapUtil;
import org.silverpeas.kernel.util.StringUtil;

@Repository
public class UserDAO {
    private static final String USER_TABLE = "st_user";
    private static final String GROUP_USER_REL_TABLE = "st_group_user_rel";
    private static final String USER_COLUMNS = "DISTINCT(st_user.id),st_user.specificId,st_user.domainId,login,firstName,lastName,loginMail,email,accessLevel,loginQuestion,loginAnswer,st_user.creationDate,st_user.saveDate,version,tosAcceptanceDate,lastLoginDate,nbSuccessfulLoginAttempts,lastLoginCredentialUpdateDate,expirationDate,st_user.state,st_user.stateSaveDate, notifManualReceiverLimit, sensitiveData";
    private static final String STATE_CRITERION = "state = ?";
    private static final String ID_CRITERION = "id = ?";
    private static final String DOMAIN_ID_CRITERION = "domainId = ?";
    private static final String ACCESS_LEVEL_CRITERION = "accessLevel = ?";
    private static final String USER_ID_JOINTURE = "id = userId";
    private static final String ACCESS_LEVEL = "accessLevel";
    private static final String LAST_NAME = "lastName";
    private static final String FIRST_NAME = "firstName";
    private static final String DOMAIN_ID = "domainId";
    private static final String SPECIFIC_ID = "specificId";
    private static final String STATE = "state";
    private static final String LOGIN = "login";
    private static final String SAVE_DATE = "saveDate";
    private static final String STATE_SAVE_DATE = "stateSaveDate";

    protected UserDAO() {
    }

    public String addUser(Connection connection, UserDetail user) throws SQLException {
        int nextId = DBUtil.getNextId((String)USER_TABLE);
        Instant now = new Date().toInstant();
        if (UserState.UNKNOWN.equals((Object)user.getState())) {
            user.setState(UserState.VALID);
        }
        JdbcSqlQuery.insertInto((String)USER_TABLE).withInsertParam("id", (Object)nextId).withInsertParam(SPECIFIC_ID, (Object)user.getSpecificId()).withInsertParam(DOMAIN_ID, (Object)Integer.parseInt(user.getDomainId())).withInsertParam(LOGIN, (Object)user.getLogin()).withInsertParam(FIRST_NAME, (Object)user.getFirstName()).withInsertParam(LAST_NAME, (Object)user.getLastName()).withInsertParam("loginMail", (Object)"").withInsertParam("email", (Object)user.getEmailAddress()).withInsertParam(ACCESS_LEVEL, (Object)user.getAccessLevel().code()).withInsertParam("loginQuestion", (Object)user.getLoginQuestion()).withInsertParam("loginAnswer", (Object)user.getLoginAnswer()).withInsertParam("creationDate", (Object)now).withInsertParam(SAVE_DATE, (Object)now).withInsertParam("version", (Object)0).withInsertParam("tosAcceptanceDate", (Object)this.toInstant(user.getTosAcceptanceDate())).withInsertParam("lastLoginDate", (Object)this.toInstant(user.getLastLoginDate())).withInsertParam("nbSuccessfulLoginAttempts", (Object)user.getNbSuccessfulLoginAttempts()).withInsertParam("lastLoginCredentialUpdateDate", (Object)this.toInstant(user.getLastLoginCredentialUpdateDate())).withInsertParam("expirationDate", (Object)this.toInstant(user.getExpirationDate())).withInsertParam(STATE, (Object)user.getState()).withInsertParam(STATE_SAVE_DATE, (Object)now).withInsertParam("notifManualReceiverLimit", (Object)user.getNotifManualReceiverLimit()).executeWith(connection);
        return String.valueOf(nextId);
    }

    public void restoreUser(Connection connection, UserDetail user) throws SQLException {
        Instant now = new Date().toInstant();
        JdbcSqlQuery.update((String)USER_TABLE).withUpdateParam(STATE, (Object)UserState.VALID).withUpdateParam(STATE_SAVE_DATE, (Object)now).withUpdateParam(SAVE_DATE, (Object)now).where(ID_CRITERION, new Object[]{Integer.parseInt(user.getId())}).and(STATE, new Object[0]).in(new Object[]{UserState.REMOVED}).executeWith(connection);
    }

    public void removeUser(Connection connection, UserDetail user) throws SQLException {
        Instant now = new Date().toInstant();
        JdbcSqlQuery.update((String)USER_TABLE).withUpdateParam(STATE, (Object)UserState.REMOVED).withUpdateParam(STATE_SAVE_DATE, (Object)now).withUpdateParam(SAVE_DATE, (Object)now).where(ID_CRITERION, new Object[]{Integer.parseInt(user.getId())}).and(STATE, new Object[0]).notIn(new Object[]{UserState.REMOVED, UserState.DELETED}).executeWith(connection);
    }

    public void deleteUser(Connection connection, UserDetail user) throws SQLException {
        Instant now = new Date().toInstant();
        JdbcSqlQuery.update((String)USER_TABLE).withUpdateParam(LOGIN, (Object)("???REM???" + user.getId())).withUpdateParam(SPECIFIC_ID, (Object)("???REM???" + user.getId())).withUpdateParam(STATE, (Object)UserState.DELETED).withUpdateParam(STATE_SAVE_DATE, (Object)now).withUpdateParam(SAVE_DATE, (Object)now).where(ID_CRITERION, new Object[]{Integer.parseInt(user.getId())}).executeWith(connection);
    }

    public UserDetail getUserById(Connection connection, String id) throws SQLException {
        return (UserDetail)JdbcSqlQuery.select((String)USER_COLUMNS).from(new String[]{USER_TABLE}).where(ID_CRITERION, new Object[]{Integer.parseInt(id)}).executeUniqueWith(connection, UserDAO::fetchUser);
    }

    public List<UserDetail> getUserByIds(Connection connection, Collection<String> ids) throws SQLException {
        return JdbcSqlQuery.streamBySplittingOn((Collection)ids.stream().filter(StringUtil::isDefined).map(Integer::parseInt).collect(Collectors.toList()), idBatch -> JdbcSqlQuery.select((String)USER_COLUMNS).from(new String[]{USER_TABLE}).where("id", new Object[0]).in(idBatch).executeWith(connection, UserDAO::fetchUser)).collect(Collectors.toList());
    }

    public boolean isUserByIdExists(Connection connection, String id) throws SQLException {
        return (Integer)JdbcSqlQuery.select((String)"COUNT(id)").from(new String[]{USER_TABLE}).where(ID_CRITERION, new Object[]{Integer.parseInt(id)}).and(STATE, new Object[0]).notIn(new Object[]{UserState.DELETED}).executeUniqueWith(connection, row -> row.getInt(1)) == 1;
    }

    public UserDetail getUserBySpecificId(Connection connection, String domainId, String specificId) throws SQLException {
        return (UserDetail)JdbcSqlQuery.select((String)USER_COLUMNS).from(new String[]{USER_TABLE}).where(DOMAIN_ID_CRITERION, new Object[]{Integer.parseInt(domainId)}).and("specificId = ?", new Object[]{specificId}).executeUniqueWith(connection, UserDAO::fetchUser);
    }

    public List<UserDetail> getUsersBySpecificIds(Connection connection, String domainId, Collection<String> specificIds) throws SQLException {
        return JdbcSqlQuery.streamBySplittingOn(specificIds, idBatch -> JdbcSqlQuery.select((String)USER_COLUMNS).from(new String[]{USER_TABLE}).where(DOMAIN_ID_CRITERION, new Object[]{Integer.parseInt(domainId)}).and(SPECIFIC_ID, new Object[0]).in(idBatch).executeWith(connection, UserDAO::fetchUser)).collect(Collectors.toList());
    }

    public List<UserDetail> getRemovedUsers(Connection connection, String ... domainIds) throws SQLException {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(domainIds);
        JdbcSqlQuery query = JdbcSqlQuery.select((String)USER_COLUMNS).from(new String[]{USER_TABLE}).where(STATE_CRITERION, new Object[]{UserState.REMOVED});
        UserDAO.filterOnDomainIds(query, domainIds);
        return query.executeWith(connection, UserDAO::fetchUser);
    }

    private static void filterOnDomainIds(JdbcSqlQuery query, String[] domainIds) {
        List requestedDomainIds = Stream.of(domainIds).map(Integer::parseInt).collect(Collectors.toList());
        if (!requestedDomainIds.isEmpty()) {
            query.and(DOMAIN_ID, new Object[0]).in(requestedDomainIds);
        }
    }

    public List<UserDetail> getNonBlankedDeletedUsers(Connection connection, String ... domainIds) throws SQLException {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(domainIds);
        JdbcSqlQuery query = JdbcSqlQuery.select((String)USER_COLUMNS).from(new String[]{USER_TABLE}).where(STATE_CRITERION, new Object[]{UserState.DELETED}).and("firstName <> ?", new Object[]{"_Anonymous_"});
        UserDAO.filterOnDomainIds(query, domainIds);
        return query.executeWith(connection, UserDAO::fetchUser);
    }

    public List<UserDetail> getUsersWithSensitiveData(@Nonnull Connection connection, String ... domainIds) throws SQLException {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(domainIds);
        JdbcSqlQuery query = JdbcSqlQuery.select((String)USER_COLUMNS).from(new String[]{USER_TABLE}).where("sensitiveData = ?", new Object[]{true}).and(STATE, new Object[0]).notIn(new Object[]{UserState.REMOVED, UserState.DELETED});
        UserDAO.filterOnDomainIds(query, domainIds);
        return query.executeWith(connection, UserDAO::fetchUser);
    }

    public String getUserIdByLoginAndDomain(Connection connection, String login, String domainId) throws SQLException {
        return (String)JdbcSqlQuery.select((String)"id").from(new String[]{USER_TABLE}).where(DOMAIN_ID_CRITERION, new Object[]{Integer.parseInt(domainId)}).and("lower(login) = lower(?)", new Object[]{login}).and(STATE, new Object[0]).notIn(new Object[]{UserState.DELETED}).executeUniqueWith(connection, r -> Integer.toString(r.getInt(1)));
    }

    public boolean isUserEmailExisting(Connection connection, String email) throws SQLException {
        return (Integer)JdbcSqlQuery.select((String)"COUNT(id)").from(new String[]{USER_TABLE}).where("email = ?", new Object[]{email}).executeUniqueWith(connection, row -> row.getInt(1)) > 1;
    }

    public void blankUser(Connection connection, UserDetail user) throws SQLException {
        user.setFirstName("_Anonymous_");
        user.setLastName("");
        user.setEmailAddress("");
        this.updateUser(connection, user);
    }

    public void updateUser(Connection connection, UserDetail user) throws SQLException {
        Instant now = new Date().toInstant();
        String firstName = user.isBlanked() ? "_Anonymous_" : user.getFirstName();
        JdbcSqlQuery.update((String)USER_TABLE).withUpdateParam(SPECIFIC_ID, (Object)user.getSpecificId()).withUpdateParam(DOMAIN_ID, (Object)Integer.parseInt(user.getDomainId())).withUpdateParam(LOGIN, (Object)user.getLogin()).withUpdateParam(FIRST_NAME, (Object)firstName).withUpdateParam(LAST_NAME, (Object)user.getLastName()).withUpdateParam("email", (Object)user.getEmailAddress()).withUpdateParam(ACCESS_LEVEL, (Object)user.getAccessLevel().code()).withUpdateParam("loginQuestion", (Object)user.getLoginQuestion()).withUpdateParam("loginAnswer", (Object)user.getLoginAnswer()).withUpdateParam(SAVE_DATE, (Object)now).withUpdateParam("version", (Object)(user.getVersion() + 1)).withUpdateParam("tosAcceptanceDate", (Object)this.toInstant(user.getTosAcceptanceDate())).withUpdateParam("lastLoginDate", (Object)this.toInstant(user.getLastLoginDate())).withUpdateParam("nbSuccessfulLoginAttempts", (Object)user.getNbSuccessfulLoginAttempts()).withUpdateParam("lastLoginCredentialUpdateDate", (Object)this.toInstant(user.getLastLoginCredentialUpdateDate())).withUpdateParam("expirationDate", (Object)this.toInstant(user.getExpirationDate())).withUpdateParam(STATE, (Object)user.getState()).withUpdateParam(STATE_SAVE_DATE, (Object)this.toInstant(user.getStateSaveDate())).withUpdateParam("notifManualReceiverLimit", (Object)user.getNotifManualReceiverLimit()).withUpdateParam("sensitiveData", (Object)user.hasSensitiveData()).where(ID_CRITERION, new Object[]{Integer.parseInt(user.getId())}).executeWith(connection);
    }

    public ListSlice<UserDetail> getUsersByCriteria(Connection connection, UserDetailsSearchCriteria criteria) throws SQLException {
        SqlUserSelectorByCriteriaBuilder builder = new SqlUserSelectorByCriteriaBuilder(USER_COLUMNS);
        return builder.build(criteria).executeWith(connection, UserDAO::fetchUser);
    }

    public int getUserCountByCriteria(Connection connection, UserDetailsSearchCriteria criteria) throws SQLException {
        SqlUserSelectorByCriteriaBuilder builder = new SqlUserSelectorByCriteriaBuilder("COUNT(DISTINCT st_user.id)");
        return (Integer)builder.build(criteria).executeUniqueWith(connection, row -> row.getInt(1));
    }

    public List<UserDetail> getUsersInGroups(Connection con, List<String> groupIds) throws SQLException {
        List groupIdsAsInt = groupIds.stream().map(Integer::parseInt).collect(Collectors.toList());
        return JdbcSqlQuery.select((String)USER_COLUMNS).from(new String[]{USER_TABLE, GROUP_USER_REL_TABLE}).where(USER_ID_JOINTURE, new Object[0]).and("groupid", new Object[0]).in(groupIdsAsInt).and(STATE, new Object[0]).notIn(new Object[]{UserState.REMOVED, UserState.DELETED}).orderBy(new String[]{LAST_NAME}).executeWith(con, UserDAO::fetchUser);
    }

    public List<String> getAllUserIds(Connection connection) throws SQLException {
        return JdbcSqlQuery.select((String)"id").from(new String[]{USER_TABLE}).where(STATE, new Object[0]).notIn(new Object[]{UserState.REMOVED, UserState.DELETED}).orderBy(new String[]{LAST_NAME}).executeWith(connection, row -> Integer.toString(row.getInt(1)));
    }

    public List<String> getAllAdminIds(Connection connection, UserDetail fromUser) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)"id").from(new String[]{USER_TABLE}).where(STATE, new Object[0]).notIn(new Object[]{UserState.REMOVED, UserState.DELETED});
        query.and(ACCESS_LEVEL_CRITERION, new Object[]{UserAccessLevel.ADMINISTRATOR.code()});
        if (!fromUser.isAccessAdmin() && !fromUser.isAccessDomainManager()) {
            query.or("(accessLevel = ? and domainId = ?)", new Object[]{UserAccessLevel.DOMAIN_ADMINISTRATOR.code(), Integer.parseInt(fromUser.getDomainId())});
        }
        return query.orderBy(new String[]{LAST_NAME}).executeWith(connection, row -> Integer.toString(row.getInt(1)));
    }

    public List<String> getDirectUserIdsInGroup(Connection connection, String groupId, boolean includeRemoved) throws SQLException {
        return this.getDirectUserIdsByGroup(connection, Collections.singletonList(groupId), includeRemoved).getOrDefault(groupId, Collections.emptyList());
    }

    public Map<String, List<String>> getDirectUserIdsByGroup(Connection connection, List<String> groupIds, boolean includeRemoved) throws SQLException {
        Object[] objectArray;
        if (includeRemoved) {
            Object[] objectArray2 = new UserState[1];
            objectArray = objectArray2;
            objectArray2[0] = UserState.DELETED;
        } else {
            UserState[] userStateArray = new UserState[2];
            userStateArray[0] = UserState.REMOVED;
            objectArray = userStateArray;
            userStateArray[1] = UserState.DELETED;
        }
        Object[] userStatesToExclude = objectArray;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(groupIds.size());
        if (!groupIds.isEmpty()) {
            JdbcSqlQuery.select((String)"groupid, userid").from(new String[]{USER_TABLE, GROUP_USER_REL_TABLE}).where(USER_ID_JOINTURE, new Object[0]).and("groupId", new Object[0]).in((Collection)groupIds.stream().map(Integer::parseInt).collect(Collectors.toList())).and(STATE, new Object[0]).notIn(userStatesToExclude).orderBy(new String[]{LAST_NAME}).executeWith(connection, row -> MapUtil.putAddList(result, Integer.toString(row.getInt(1)), Integer.toString(row.getInt(2))));
        }
        return result;
    }

    public List<String> getUserIdsInGroups(Connection con, List<String> groupIds) throws SQLException {
        List groupIdsAsInt = groupIds.stream().map(Integer::parseInt).collect(Collectors.toList());
        return JdbcSqlQuery.select((String)"id").from(new String[]{USER_TABLE, GROUP_USER_REL_TABLE}).where(USER_ID_JOINTURE, new Object[0]).and("groupid", new Object[0]).in(groupIdsAsInt).and(STATE, new Object[0]).notIn(new Object[]{UserState.REMOVED, UserState.DELETED}).orderBy(new String[]{LAST_NAME}).executeWith(con, row -> Integer.toString(row.getInt(1)));
    }

    public List<String> getUserIdsInDomain(Connection connection, String domainId) throws SQLException {
        return JdbcSqlQuery.select((String)"id").from(new String[]{USER_TABLE}).where(STATE, new Object[0]).notIn(new Object[]{UserState.REMOVED, UserState.DELETED}).and(DOMAIN_ID_CRITERION, new Object[]{Integer.parseInt(domainId)}).orderBy(new String[]{LAST_NAME}).executeWith(connection, row -> Integer.toString(row.getInt(1)));
    }

    public List<String> getUserIdsByAccessLevel(Connection connection, UserAccessLevel accessLevel) throws SQLException {
        return JdbcSqlQuery.select((String)"id").from(new String[]{USER_TABLE}).where(STATE, new Object[0]).notIn(new Object[]{UserState.REMOVED, UserState.DELETED}).and(ACCESS_LEVEL_CRITERION, new Object[]{accessLevel.code()}).orderBy(new String[]{LAST_NAME}).executeWith(connection, row -> Integer.toString(row.getInt(1)));
    }

    public List<String> getUserIdsByAccessLevelInDomain(Connection connection, UserAccessLevel accessLevel, String domainId) throws SQLException {
        return JdbcSqlQuery.select((String)"id").from(new String[]{USER_TABLE}).where(STATE, new Object[0]).notIn(new Object[]{UserState.REMOVED, UserState.DELETED}).and(DOMAIN_ID_CRITERION, new Object[]{Integer.parseInt(domainId)}).and(ACCESS_LEVEL_CRITERION, new Object[]{accessLevel.code()}).orderBy(new String[]{LAST_NAME}).executeWith(connection, row -> Integer.toString(row.getInt(1)));
    }

    public List<String> getUserIdsByUserRole(Connection connection, String userRoleId, boolean includeRemoved) throws SQLException {
        Object[] objectArray;
        if (includeRemoved) {
            Object[] objectArray2 = new UserState[1];
            objectArray = objectArray2;
            objectArray2[0] = UserState.DELETED;
        } else {
            UserState[] userStateArray = new UserState[2];
            userStateArray[0] = UserState.REMOVED;
            objectArray = userStateArray;
            userStateArray[1] = UserState.DELETED;
        }
        Object[] userStatesToExclude = objectArray;
        return JdbcSqlQuery.select((String)"id").from(new String[]{USER_TABLE, "ST_UserRole_User_Rel"}).where(USER_ID_JOINTURE, new Object[0]).and("userRoleId = ?", new Object[]{Integer.parseInt(userRoleId)}).and(STATE, new Object[0]).notIn(userStatesToExclude).orderBy(new String[]{LAST_NAME}).executeWith(connection, row -> Integer.toString(row.getInt(1)));
    }

    public List<String> getUserIdsBySpaceUserRole(Connection connection, String spaceUserRoleId, boolean includeRemoved) throws SQLException {
        Object[] objectArray;
        if (includeRemoved) {
            Object[] objectArray2 = new UserState[1];
            objectArray = objectArray2;
            objectArray2[0] = UserState.DELETED;
        } else {
            UserState[] userStateArray = new UserState[2];
            userStateArray[0] = UserState.REMOVED;
            objectArray = userStateArray;
            userStateArray[1] = UserState.DELETED;
        }
        Object[] userStatesToExclude = objectArray;
        return JdbcSqlQuery.select((String)"id").from(new String[]{USER_TABLE, "ST_SpaceUserRole_User_Rel"}).where(USER_ID_JOINTURE, new Object[0]).and("spaceUserRoleId = ?", new Object[]{Integer.parseInt(spaceUserRoleId)}).and(STATE, new Object[0]).notIn(userStatesToExclude).orderBy(new String[]{LAST_NAME}).executeWith(connection, row -> Integer.toString(row.getInt(1)));
    }

    public List<String> getDirectUserIdsByGroupUserRole(Connection connection, String groupUserRoleId, boolean includeRemoved) throws SQLException {
        Object[] objectArray;
        if (includeRemoved) {
            Object[] objectArray2 = new UserState[1];
            objectArray = objectArray2;
            objectArray2[0] = UserState.DELETED;
        } else {
            UserState[] userStateArray = new UserState[2];
            userStateArray[0] = UserState.REMOVED;
            objectArray = userStateArray;
            userStateArray[1] = UserState.DELETED;
        }
        Object[] userStatesToExclude = objectArray;
        return JdbcSqlQuery.select((String)"id").from(new String[]{USER_TABLE, "ST_GroupUserRole_User_Rel"}).where(USER_ID_JOINTURE, new Object[0]).and("groupUserRoleId = ?", new Object[]{Integer.parseInt(groupUserRoleId)}).and(STATE, new Object[0]).notIn(userStatesToExclude).orderBy(new String[]{LAST_NAME}).executeWith(connection, row -> Integer.toString(row.getInt(1)));
    }

    public List<UserDetail> getAllUsers(Connection con) throws SQLException {
        return this.getAllUsers(con, null, null);
    }

    public List<UserDetail> getAllUsersFromNewestToOldest(Connection con) throws SQLException {
        return this.getAllUsers(con, null, "id DESC");
    }

    private List<UserDetail> getAllUsers(Connection con, List<String> domainIds, String orderBy) throws SQLException {
        String order = StringUtil.isDefined((String)orderBy) ? orderBy : LAST_NAME;
        JdbcSqlQuery query = JdbcSqlQuery.select((String)USER_COLUMNS).from(new String[]{USER_TABLE}).where(STATE, new Object[0]).notIn(new Object[]{UserState.REMOVED, UserState.DELETED});
        if (domainIds != null && !domainIds.isEmpty()) {
            List domainIdsAsInt = domainIds.stream().map(Integer::parseInt).collect(Collectors.toList());
            query.and(DOMAIN_ID, new Object[0]).in(domainIdsAsInt);
        }
        return query.orderBy(new String[]{order}).executeWith(con, UserDAO::fetchUser);
    }

    public List<UserDetail> getUsersOfDomains(Connection con, List<String> domainIds) throws SQLException {
        return this.getAllUsers(con, domainIds, null);
    }

    public List<UserDetail> getUsersOfDomainsFromNewestToOldest(Connection con, List<String> domainIds) throws SQLException {
        return this.getAllUsers(con, domainIds, "id DESC");
    }

    private static UserDetail fetchUser(ResultSet rs) throws SQLException {
        UserDetail u = new UserDetail();
        u.setId(Integer.toString(rs.getInt(1)));
        u.setSpecificId(rs.getString(2));
        u.setDomainId(Integer.toString(rs.getInt(3)));
        u.setLogin(rs.getString(4));
        u.setFirstName(rs.getString(5));
        u.setLastName(rs.getString(6));
        u.setEmailAddress(rs.getString(8));
        u.setAccessLevel(UserAccessLevel.fromCode((String)rs.getString(9)));
        u.setLoginQuestion(rs.getString(10));
        u.setLoginAnswer(rs.getString(11));
        u.setCreationDate(rs.getTimestamp(12));
        u.setSaveDate(rs.getTimestamp(13));
        u.setVersion(rs.getInt(14));
        u.setTosAcceptanceDate(rs.getTimestamp(15));
        u.setLastLoginDate(rs.getTimestamp(16));
        u.setNbSuccessfulLoginAttempts(rs.getInt(17));
        u.setLastLoginCredentialUpdateDate(rs.getTimestamp(18));
        u.setExpirationDate(rs.getTimestamp(19));
        u.setState(UserState.from((String)rs.getString(20)));
        u.setStateSaveDate(rs.getTimestamp(21));
        if (StringUtil.isInteger((String)rs.getString(22))) {
            u.setNotifManualReceiverLimit(rs.getInt(22));
        }
        u.setSensitiveData(rs.getBoolean(23));
        return u;
    }

    private Instant toInstant(Date aDate) {
        return aDate == null ? null : aDate.toInstant();
    }
}

