/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.space.quota;

import org.silverpeas.core.admin.quota.constant.QuotaType;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.PersonalSpaceManager;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.quota.AbstractSpaceQuotaKey;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.kernel.util.StringUtil;

public class DataStorageSpaceQuotaKey
extends AbstractSpaceQuotaKey {
    private final User user;

    public static DataStorageSpaceQuotaKey from(UserDetail user) {
        return new DataStorageSpaceQuotaKey(PersonalSpaceManager.get().getPersonalSpace(user.getId()), user);
    }

    public static DataStorageSpaceQuotaKey from(SpaceInst space) {
        return new DataStorageSpaceQuotaKey(space, space.isPersonalSpace() ? space.getCreator() : null);
    }

    public static DataStorageSpaceQuotaKey from(String componentInstanceId) {
        SpaceInst space = OrganizationControllerProvider.getOrganisationController().getSpaceInstById(OrganizationControllerProvider.getOrganisationController().getComponentInst(componentInstanceId).getDomainFatherId());
        return DataStorageSpaceQuotaKey.from(space);
    }

    private DataStorageSpaceQuotaKey(SpaceInst space, User user) {
        super(space);
        this.user = user;
    }

    @Override
    public boolean isValid() {
        return this.user != null && StringUtil.isDefined((String)this.user.getId()) || super.isValid();
    }

    @Override
    public QuotaType getQuotaType() {
        return this.user != null ? QuotaType.DATA_STORAGE_IN_USER_SPACE : QuotaType.DATA_STORAGE_IN_SPACE;
    }

    @Override
    public String getResourceId() {
        return this.user != null ? this.user.getId() : super.getResourceId();
    }

    public User getUser() {
        return this.user;
    }
}

