/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.space;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.persistence.OrganizationSchema;
import org.silverpeas.core.admin.persistence.SpaceUserRoleRow;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.space.SpaceProfileInst;
import org.silverpeas.core.admin.space.notification.SpaceProfileInstEventNotifier;
import org.silverpeas.core.admin.user.GroupManager;
import org.silverpeas.core.admin.user.UserManager;
import org.silverpeas.core.admin.user.dao.SpaceRoleDAO;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
@Transactional(value=Transactional.TxType.MANDATORY)
public class SpaceProfileInstManager {
    public static final String SPACE_PROFILES_OF_USER = "space profiles of user";
    public static final String SPACE_PROFILE = "space profile";
    @Inject
    private OrganizationSchema organizationSchema;
    @Inject
    private SpaceRoleDAO spaceRoleDAO;
    @Inject
    private SpaceProfileInstEventNotifier notifier;

    protected SpaceProfileInstManager() {
    }

    public String[] getSpaceProfileIdsOfUserType(String sUserId) throws AdminException {
        try {
            SpaceUserRoleRow[] tabSpaceUserRole;
            ArrayList<String> roleIds = new ArrayList<String>();
            for (SpaceUserRoleRow role : tabSpaceUserRole = this.organizationSchema.spaceUserRole().getDirectSpaceUserRolesOfUser(Integer.parseInt(sUserId))) {
                roleIds.add(Integer.toString(role.getId()));
            }
            return roleIds.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)SPACE_PROFILES_OF_USER, (Object)sUserId), e);
        }
    }

    public String[] getSpaceProfileIdsOfGroupType(String groupId) throws AdminException {
        try {
            SpaceUserRoleRow[] tabSpaceGroupRole;
            ArrayList<String> roleIds = new ArrayList<String>();
            for (SpaceUserRoleRow role : tabSpaceGroupRole = this.organizationSchema.spaceUserRole().getDirectSpaceUserRolesOfGroup(Integer.parseInt(groupId))) {
                roleIds.add(Integer.toString(role.getId()));
            }
            return roleIds.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"space profiles of group", (Object)groupId), e);
        }
    }

    public List<String> getSpaceProfileNamesOfUser(String userId, List<String> groupIds, int spaceLocalId) throws AdminException {
        List<String> list;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                list = this.spaceRoleDAO.getSpaceRoles(con, groupIds, Integer.parseInt(userId), Collections.singleton(spaceLocalId)).stream().map(SpaceUserRoleRow::getRoleName).distinct().collect(Collectors.toList());
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)SPACE_PROFILES_OF_USER, (Object)userId), e);
                }
            }
            con.close();
        }
        return list;
    }

    public Map<Integer, Set<String>> getSpaceProfileNamesOfUser(String userId, List<String> groupIds, Collection<Integer> spaceLocalIds) throws AdminException {
        Map<Integer, Set<String>> map;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                map = this.spaceRoleDAO.getSpaceRoles(con, groupIds, Integer.parseInt(userId), spaceLocalIds).stream().collect(Collectors.groupingBy(SpaceUserRoleRow::getSpaceId, Collectors.mapping(SpaceUserRoleRow::getRoleName, Collectors.toSet())));
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)SPACE_PROFILES_OF_USER, (Object)userId), e);
                }
            }
            con.close();
        }
        return map;
    }

    public String createSpaceProfileInst(SpaceProfileInst spaceProfileInst, int parentSpaceLocalId) throws AdminException {
        try {
            SpaceUserRoleRow newRole = SpaceUserRoleRow.from(spaceProfileInst);
            newRole.setSpaceId(parentSpaceLocalId);
            this.organizationSchema.spaceUserRole().createSpaceUserRole(newRole);
            String spaceProfileNodeId = SpaceProfileInstManager.idAsString(newRole.getId());
            for (String groupId : spaceProfileInst.getAllGroups()) {
                this.organizationSchema.spaceUserRole().addGroupInSpaceUserRole(this.idAsInt(groupId), this.idAsInt(spaceProfileNodeId));
            }
            for (String userId : spaceProfileInst.getAllUsers()) {
                this.organizationSchema.spaceUserRole().addUserInSpaceUserRole(this.idAsInt(userId), this.idAsInt(spaceProfileNodeId));
            }
            this.notifier.notifyEventOn(ResourceEvent.Type.CREATION, new SpaceProfileInst[]{spaceProfileInst});
            return spaceProfileNodeId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)SPACE_PROFILE, (Object)spaceProfileInst.getName()), e);
        }
    }

    public SpaceProfileInst getSpaceProfileInst(String spaceProfileId, boolean includeRemovedUsersAndGroups) throws AdminException {
        try {
            SpaceUserRoleRow spaceUserRole = this.organizationSchema.spaceUserRole().getSpaceUserRole(this.idAsInt(spaceProfileId));
            SpaceProfileInst spaceProfileInst = null;
            if (spaceUserRole != null) {
                spaceProfileInst = this.spaceUserRoleRow2SpaceProfileInst(spaceUserRole);
                this.setUsersAndGroups(spaceProfileInst, includeRemovedUsersAndGroups);
            }
            return spaceProfileInst;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)SPACE_PROFILE, (Object)spaceProfileId), e);
        }
    }

    public SpaceProfileInst getInheritedSpaceProfileInstByName(int spaceLocalId, String roleName) throws AdminException {
        return this.getSpaceProfileInst(spaceLocalId, roleName, true);
    }

    public SpaceProfileInst getSpaceProfileInstByName(int spaceLocalId, String roleName) throws AdminException {
        return this.getSpaceProfileInst(spaceLocalId, roleName, false);
    }

    private SpaceProfileInst getSpaceProfileInst(int spaceLocalId, String roleName, boolean isInherited) throws AdminException {
        try {
            int inherited = 0;
            if (isInherited) {
                inherited = 1;
            }
            SpaceUserRoleRow spaceUserRole = this.organizationSchema.spaceUserRole().getSpaceUserRole(spaceLocalId, roleName, inherited);
            SpaceProfileInst spaceProfileInst = null;
            if (spaceUserRole != null) {
                spaceProfileInst = this.spaceUserRoleRow2SpaceProfileInst(spaceUserRole);
                this.setUsersAndGroups(spaceProfileInst, false);
            }
            return spaceProfileInst;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)SPACE_PROFILE, (Object)roleName), e);
        }
    }

    private void setUsersAndGroups(SpaceProfileInst spaceProfileInst, boolean includeRemovedUsersAndGroups) throws AdminException {
        List<String> groupIds = GroupManager.get().getDirectGroupIdsInSpaceRole(spaceProfileInst.getId(), includeRemovedUsersAndGroups);
        spaceProfileInst.setGroups(groupIds);
        List<String> userIds = UserManager.get().getDirectUserIdsInSpaceRole(spaceProfileInst.getId(), includeRemovedUsersAndGroups);
        spaceProfileInst.setUsers(userIds);
    }

    private SpaceProfileInst spaceUserRoleRow2SpaceProfileInst(SpaceUserRoleRow spaceUserRole) {
        SpaceProfileInst spaceProfileInst = new SpaceProfileInst();
        spaceProfileInst.setId(Integer.toString(spaceUserRole.getId()));
        spaceProfileInst.setName(spaceUserRole.getRoleName());
        spaceProfileInst.setLabel(spaceUserRole.getName());
        spaceProfileInst.setDescription(spaceUserRole.getDescription());
        spaceProfileInst.setSpaceFatherId(Integer.toString(spaceUserRole.getSpaceId()));
        if (spaceUserRole.getInheritance() == 1) {
            spaceProfileInst.setInherited(true);
        }
        return spaceProfileInst;
    }

    public void deleteSpaceProfileInst(SpaceProfileInst spaceProfileInst) throws AdminException {
        try {
            this.organizationSchema.spaceUserRole().removeSpaceUserRole(this.idAsInt(spaceProfileInst.getId()));
            this.notifier.notifyEventOn(ResourceEvent.Type.DELETION, new SpaceProfileInst[]{spaceProfileInst});
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)SPACE_PROFILE, (Object)spaceProfileInst.getId()), e);
        }
    }

    public String updateSpaceProfileInst(SpaceProfileInst spaceProfileInst, SpaceProfileInst spaceProfileInstNew) throws AdminException {
        try {
            List<String> alOldSpaceProfileGroup = spaceProfileInst.getAllGroups();
            List<String> alNewSpaceProfileGroup = spaceProfileInstNew.getAllGroups();
            for (String groupId : alNewSpaceProfileGroup) {
                if (alOldSpaceProfileGroup.contains(groupId)) continue;
                this.organizationSchema.spaceUserRole().addGroupInSpaceUserRole(this.idAsInt(groupId), this.idAsInt(spaceProfileInst.getId()));
            }
            for (String groupId : alOldSpaceProfileGroup) {
                if (alNewSpaceProfileGroup.contains(groupId)) continue;
                this.organizationSchema.spaceUserRole().removeGroupFromSpaceUserRole(this.idAsInt(groupId), this.idAsInt(spaceProfileInst.getId()));
            }
            List<String> alOldSpaceProfileUser = spaceProfileInst.getAllUsers();
            List<String> alNewSpaceProfileUser = spaceProfileInstNew.getAllUsers();
            for (String userId : alOldSpaceProfileUser) {
                if (alNewSpaceProfileUser.contains(userId)) continue;
                this.organizationSchema.spaceUserRole().removeUserFromSpaceUserRole(this.idAsInt(userId), this.idAsInt(spaceProfileInst.getId()));
            }
            for (String userId : alNewSpaceProfileUser) {
                if (alOldSpaceProfileUser.contains(userId)) continue;
                this.organizationSchema.spaceUserRole().addUserInSpaceUserRole(this.idAsInt(userId), this.idAsInt(spaceProfileInst.getId()));
            }
            SpaceUserRoleRow changedSpaceUserRole = SpaceUserRoleRow.from(spaceProfileInstNew);
            changedSpaceUserRole.setId(this.idAsInt(spaceProfileInstNew.getId()));
            this.organizationSchema.spaceUserRole().updateSpaceUserRole(changedSpaceUserRole);
            this.notifier.notifyEventOn(ResourceEvent.Type.UPDATE, new SpaceProfileInst[]{spaceProfileInst, spaceProfileInstNew});
            return SpaceProfileInstManager.idAsString(changedSpaceUserRole.getId());
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)SPACE_PROFILE, (Object)spaceProfileInst.getId()), e);
        }
    }

    private int idAsInt(String id) {
        return StringUtil.asInt((String)id, (int)-1);
    }

    private static String idAsString(int id) {
        return Integer.toString(id);
    }
}

