/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.upload;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.webapi.upload.UploadedRequestFile;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class FileUploadData {
    static final String X_COMPONENT_INSTANCE_ID = "X-COMPONENT-INSTANCE-ID";
    static final String X_UPLOAD_SESSION = "X-UPLOAD-SESSION";
    static final String X_FULL_PATH = "X-FULL-PATH";
    private String uploadSessionId;
    private String fullPath;
    private String name;
    private String componentInstanceId;

    private FileUploadData(String uploadSessionId, String fullPath, String componentInstanceId) {
        if (StringUtil.isDefined((String)fullPath) && fullPath.contains("..")) {
            SilverLogger.getLogger((String)"silverpeas.core.security").error("Path Traversal attack detected at {0}", new Object[]{LocalDateTime.now().toString()});
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        this.uploadSessionId = uploadSessionId;
        this.fullPath = fullPath;
        this.name = StringUtil.isDefined((String)fullPath) ? new File(fullPath).getName() : "";
        this.componentInstanceId = componentInstanceId;
    }

    public String getUploadSessionId() {
        return this.uploadSessionId;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getName() {
        return this.name;
    }

    public String getComponentInstanceId() {
        return this.componentInstanceId;
    }

    public static FileUploadData from(HttpServletRequest request) throws UnsupportedEncodingException {
        String brutFullPath = request.getHeader(X_FULL_PATH);
        if (StringUtil.isNotDefined((String)brutFullPath)) {
            brutFullPath = "";
        }
        String fullPath = URLDecoder.decode(brutFullPath, Charsets.UTF_8.name());
        fullPath = StringUtil.normalize((String)fullPath);
        return new FileUploadData(request.getHeader(X_UPLOAD_SESSION), fullPath, request.getHeader(X_COMPONENT_INSTANCE_ID));
    }

    public static FileUploadData from(UploadedRequestFile uploadedRequestFile) {
        return new FileUploadData(uploadedRequestFile.getUploadSessionId(), uploadedRequestFile.getRequestFile().getName(), uploadedRequestFile.getComponentInstanceId());
    }
}

