/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.thesaurus;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.pdc.thesaurus.model.Synonym;
import org.silverpeas.core.pdc.thesaurus.service.ThesaurusService;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="thesaurus")
@Authorized
public class ThesaurusResource
extends RESTWebService {
    static final String PATH = "thesaurus";

    public void validateUserAuthorization(UserPrivilegeValidation validation) {
        if (!this.getUser().isAccessAdmin() && !this.getUser().isAccessPdcManager()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    @POST
    @Path(value="/vocabulary/{vocabularyId}/axis/{axisId}/values/{valueId}/synonyms")
    @Produces(value={"application/json"})
    public void setSynonyms(@PathParam(value="vocabularyId") String vocabularyId, @PathParam(value="axisId") String axisId, @PathParam(value="valueId") String valueId, @FormParam(value="synonym") Set<String> synonyms) {
        List synonymList = synonyms.stream().flatMap(s -> Arrays.stream(s.split(","))).distinct().filter(StringUtil::isDefined).map(s -> this.getNewSynonym(vocabularyId, axisId, valueId, (String)s)).collect(Collectors.toList());
        int nbLimit = ResourceLocator.getSettingBundle((String)"org.silverpeas.thesaurusPeas.settings.thesaurusSettings").getInteger("thesaurus.synonym.nbmax", 5);
        if (synonymList.size() > nbLimit) {
            throw new WebApplicationException("only " + nbLimit + " synonyms at most", Response.Status.NOT_ACCEPTABLE);
        }
        try {
            this.getThesaurusService().updateSynonyms(synonymList);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Synonym getNewSynonym(String vocabularyId, String axisId, String valueId, String name) {
        Synonym synonym = new Synonym();
        synonym.setName(name);
        synonym.setIdVoca(new Integer(vocabularyId).longValue());
        synonym.setIdTree(new Integer(axisId).longValue());
        synonym.setIdTerm(new Integer(valueId).longValue());
        return synonym;
    }

    private ThesaurusService getThesaurusService() {
        return ThesaurusService.getInstance();
    }

    protected String getResourceBasePath() {
        return PATH;
    }

    public String getComponentId() {
        return "";
    }
}

