/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.tools.agenda.control;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Date;
import org.silverpeas.core.personalorganizer.model.JournalHeader;
import org.silverpeas.core.personalorganizer.service.SilverpeasCalendar;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.web.tools.agenda.control.AgendaException;

public class AgendaAccess {
    private static SilverpeasCalendar silverpeasCalendar = null;

    private AgendaAccess() {
    }

    private static SilverpeasCalendar getSilverpeasCalendar() throws AgendaException {
        if (silverpeasCalendar == null) {
            try {
                silverpeasCalendar = (SilverpeasCalendar)ServiceProvider.getService(SilverpeasCalendar.class, (Annotation[])new Annotation[0]);
            }
            catch (Exception e) {
                throw new AgendaException(e);
            }
        }
        return silverpeasCalendar;
    }

    public static boolean hasTentativeSchedulables(String userId) throws AgendaException {
        try {
            return AgendaAccess.getSilverpeasCalendar().hasTentativeSchedulablesForUser(userId);
        }
        catch (Exception e) {
            throw new AgendaException(e);
        }
    }

    public static Date getCurrentDay() {
        return new Date();
    }

    public static Collection<JournalHeader> getDaySchedulables(String userId) throws AgendaException {
        try {
            return AgendaAccess.getSilverpeasCalendar().getDaySchedulablesForUser(DateUtil.date2SQLDate((Date)AgendaAccess.getCurrentDay()), userId, null, "accepted");
        }
        catch (Exception e) {
            throw new AgendaException(e);
        }
    }

    public static Collection<JournalHeader> getNextDaySchedulables(String userId) throws AgendaException {
        try {
            return AgendaAccess.getSilverpeasCalendar().getNextDaySchedulablesForUser(DateUtil.date2SQLDate((Date)AgendaAccess.getCurrentDay()), userId, null, "accepted");
        }
        catch (Exception e) {
            throw new AgendaException(e);
        }
    }

    public static Collection<JournalHeader> getJournalHeadersForUserAfterDate(String userIdAgenda, Date startDate, int nbReturned) throws AgendaException {
        try {
            return AgendaAccess.getSilverpeasCalendar().getJournalHeadersForUserAfterDate(userIdAgenda, startDate, nbReturned);
        }
        catch (Exception e) {
            throw new AgendaException(e);
        }
    }
}

