/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.util;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.web.util.WysiwygEditorConfig;

@Singleton
public class WysiwygEditorConfigRegistry {
    private Map<String, WysiwygEditorConfig> configsPerComponents = new ConcurrentHashMap<String, WysiwygEditorConfig>();

    protected WysiwygEditorConfigRegistry() {
    }

    public static WysiwygEditorConfigRegistry get() {
        return (WysiwygEditorConfigRegistry)ServiceProvider.getService(WysiwygEditorConfigRegistry.class, (Annotation[])new Annotation[0]);
    }

    public void register(String componentName, WysiwygEditorConfig config) {
        this.configsPerComponents.put(componentName, config);
    }

    public WysiwygEditorConfig get(String componentName) {
        WysiwygEditorConfig config = this.configsPerComponents.computeIfAbsent(componentName, WysiwygEditorConfig::new);
        return config.copy();
    }
}

